package com.digiwin.cross.domain.service.validator.bo;

import com.digiwin.cross.domain.bo.entity.EaiEntity;
import com.digiwin.cross.domain.bo.entity.ProductEntity;
import com.digiwin.cross.domain.bo.entity.ServiceEntity;
import com.digiwin.cross.domain.common.ProductType;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * @description:
 * @author: clay
 * @date: 2023/6/15
 */
@Setter
@Getter
@AllArgsConstructor
@NoArgsConstructor
public class ProviderBO {

    private ProductEntity product;

    private ServiceEntity service;

    private EaiEntity eai;

    public ProductType getProductType() {
        return null == product ? null : product.getProductType();
    }

    public boolean isAgile() {
        return product != null && ProductType.AGILE.equals(product.getProductType());
    }

}
