package com.digiwin.cross.domain.state;

import java.util.HashMap;
import java.util.Map;

/**
 * @description:
 * @author: clay
 * @date: 2023/6/1
 */
public enum StateEnum {

    //平台接收請求訊息
    MSG_RECEIVED("000"),

    //同步
//	SYNC_MSG_CHECKED("010"),
    SYNC_SRV_START_WAIT("013"),
    SYNC_CALL_REMOTE("014"),
    SYNC_REMOTE_RETURNED("015"),
    SYNC_REMOTE_RETURNED_SRV100("016"),
    SYNC_MSG_RETURNED("019"),

    //穩態同步
    UNION_CALL_CROSSSRV("0C4"),
    UNION_REMOTE_RETURNED("0C5"),
    UNION_REMOTE_RETURNED_SRV100("0C6"),
    UNION_REMOTE_RETURNED_SRV_FAILED("0C7"),

    //全異步
    FASYNC_SRV_START_WAIT("0E3"),
    FASYNC_CALL_REMOTE("0E4"),
    FASYNC_REMOTE_RETURNED("0E5"),
    FASYNC_REMOTE_RETURNED_SRV100("0E6"),
    FASYNC_MSG_RETURNED("0E9"),
    FASYNC_REMOTE_CALLBACK("0E0"),
    FASYNC_REMOTE_CALLBACKED("0EA"),
    FASYNC_REMOTE_CALLBACKED_SRV100("0EB"),
    FASYNC_CALLBACK("0ED"),
    FASYNC_CALLBACKED("0EE"),
    FASYNC_CALLBACKED_SRV100("0EF"),
    FASYNC_CALLBACK_RESULT("0EG"),

    //多廠區全異步
    UNION_FASYNC_SRV_START_WAIT("0F3"),
    UNION_FASYNC_CALL_REMOTE("0F4"),
    UNION_FASYNC_REMOTE_RETURNED("0F5"),
    UNION_FASYNC_REMOTE_RETURNED_SRV100("0F6"),
    UNION_FASYNC_MSG_RETURNED("0F9"),
    UNION_FASYNC_REMOTE_CALLBACKED("0FA"),
    UNION_FASYNC_REMOTE_CALLBACKED_SRV100("0FB"),
    UNION_FASYNC_CALLBACK("0FD"),
    UNION_FASYNC_CALLBACKED("0FE"),
    UNION_FASYNC_CALLBACKED_SRV100("0FF"),
    UNION_FASYNC_CALLBACK_RESULT("0FG"),

    //MDC
    MDC_OMMAP_NOT_FOUND("221"),
    MDC_VALIDATION_ERROR("222"),
    MDC_CONNECTION_FAIL("223"),

    //平台收到遠端互聯中台回應(遠端EAI執行服務失敗) 全異步 clay 2020-6-19
    UNION_REMOTE_RETURNED_SRV_FASYNC_FAILED("0F7"),

    //產品註冊
    REGPROD_MSG_CHECKED("050"),
    REGPROD_REGED("054"),
    REGPROD_UPDED("055"),
    REGPROD_DELED("056"),
    REGEAI_REGED("057"),
    REGEAI_UPDED("058"),
    REGEAI_DELED("059"),

    //服務註冊
    REGSRV_MSG_CHECKED("060"),
    //REGSRV_DBREGED("061"),
    //REGSRV_DBUPDED("062"),
    //REGSRV_DBDELED("063"),
    REGSRV_REGED("064"),
    REGSRV_UPDED("065"),
    REGSRV_DELED("066"),

    //產品同步
    SYNCPROD_FORMAT_ERROR("819"),
    SYNCPROD_FAILED("820"),
    SYNC_MDC_ERR("831"),
    //B2B-MQ連線測試
    MQ_CONN_SUCCESS("061"),

    //資訊查詢
    INFO_PRODLIST("091"),
    INFO_PROD("092"),
    INFO_SRVLIST("093"),
    INFO_PARAMLIST("094"),

    // 取得標準服務與詞彙表清單接口用 2017-04-12 Neville Hsieh
    GET_STANDARD_SERVICE_LIST_SUCCESS("096"),
    GET_STANDARD_DATANAME_LIST_SUCCESS("097"),



    /*
     * 2010-12-21 修改狀態碼及描述
     */

    //驗證類異常-訊息驗證
    VAL_MSG_IN_FORMAT("101"),
    VAL_MSG_IN_SECURITY("102"),
    VAL_MSG_IN_DECODING("103"),
    VAL_MSG_NOT_XML_JSON("105"),
    //請求端訊息大小超過限制
    VAL_MSG_OVERLIMIT("104"),
    VAL_MSG_IN_DECRYPT("106"),//發起方訊息解密失敗.


    //驗證類異常-服務驗證
    VAL_SRV_NAME_NOT_FOUND("201"),
    VAL_SRV_VER_NOT_FOUND("202"),
    VAL_SRV_PROVIDER_NOT_FOUND("203"),
    VAL_SRV_MORE_THAN_ONE_PROD("204"),
    VAL_REQ_PROD_NOT_FOUND("205"),
    VAL_SRV_NAME_NULL("207"),

    VAL_SRV_DEFAULT_AP_NOT_FOUND("206"),
    REST_SRV_NOT_SUPPORT("208"),
    WEBSRV_NOT_SUPPORT("209"),

    CROSS_SRV_NOT_SUPPORT_REST("211"),

    VAL_SRV_CROSS_NOT_FOUND("283"),
    VAL_REQ_CROSS_NOT_FOUND("285"),
    LOCAL_EAI_INVOKE_TENANTID_NOT_FOUND("286"),

    /*
     * 呼叫服務(產品端)異常
     * 2011-5-6 Cloude E00-20110429001 調整與服務端錯誤有關的狀態(互動)碼
     */

    //重新嘗試呼叫
    SRV_INVO_RETRY("301"),

    //無法連線
    SRV_INVO_CONN("311"),
    //WS METHOD不存在
    SRV_INVO_WS_METHOD("312"),

    //回應訊息格式錯誤
    VAL_MSG_RETURN_SRV("321"),
    //回復訊息不是XML/JSON格式
    VAL_MSG_RETURN_NOT_XML_JSON("325"),
    //服務端拋出例外
    SRV_INVO_CATCH_EXCEPTION("322"),
    //服務端回應NULL
    SRV_INVO_RETURNED_NULL("323"),
    //回應訊息解碼失敗
    VAL_MSG_RETURN_DECODING("324"),
    //回應訊息解密失敗.
    VAL_MSG_RETURN_DECRYPT("327"),
    //全異步服務端callback的reqid找不到
    FASYNC_REMOTE_CALLBACK_REQID_NOTFOUND("328"),
    //全異步服務端callback缺少reqid
    FASYNC_REMOTE_CALLBACK_MISS_REQID("329"),
    //全異步reqid已在處理中
    FASYNC_REMOTE_CALLBACK_REQID_PROCESSED("32B"),
    //服務執行逾時
    SRV_INVO_TIMEOUT("331"),


    //遠端互聯中台執行逾時 Neville 2018-4-9
    UNION_INVO_TIMEOUT("3C1"),

    //無法連線至遠端互聯中台 Neville 2018-4-9
    UNION_INVO_CONN("3C2"),

    //重新呼叫遠端互聯中台 Neville 2018-4-9
    UNION_INVO_RETRY("302"),

    //無法連線至地端/雲端中間件
    GATEWAY_CONN_FAIL("3C3"),

    //地中台故障
    GATEWAY_FUSING_FAIL("3C4"),

    /*
     * 2011-09-06 Cloude E00-20110902001 服務Concurrence控制
     */
    // 服務忙碌中
    SRV_INVO_BUSY("332"),

    /*
     * 2013-1-21 Cloude CROSS服務
     */
    CROSS_SRV_THROW_EXCEPTION("326"),

    /*
     * 回覆呼叫端異常
     * 2011-8-24 Jerry E00-20110812001 新增非同步的狀態(互動)碼
     * 2012-10-24 Lillian E00-20121018001 新增手動重新回覆非同步請求的狀態碼
     */

    //手動重新回覆非同步請求
    ASYNC_MANUAL_CALLBACK("306"),

    //請求端無法連線
    REQ_INVO_CONN("361"),
    //請求端WS METHOD不存在
    REQ_INVO_WS_METHOD("362"),

    //請求端回應訊息格式錯誤
    REQ_VAL_MSG_RETURN_SRV("371"),
    REQ_VAL_MSG_NOT_XML_JSON("376"),
    //請求端拋出例外
    REQ_INVO_CATCH_EXCEPTION("372"),
    //請求端回應NULL
    REQ_INVO_RETURNED_NULL("373"),
    //請求端回應srvcode100
    ASYNC_CALLBACKED_SRV100("374"),
    //請求端回應訊息解碼失敗
    REQ_VAL_MSG_DECODING("375"),
    //請求端回應訊息解密失敗.
    REQ_VAL_MSG_DECRYPT("377"),

    //服務執行逾時
    REQ_INVO_TIMEOUT("381"),


    /*
     * 平台錯誤
     */
    PLAT_DB("908"),
    PLAT_MQ("909"),
    PLAT_MEMORY("910"),
    PLAT_ESB_SEND_ASYNC("901"),

    PLAT_ESB_SEND_MDM("906"),

    PLAT_STUBCODE_NOTFOUND("902"),
    PLAT_STUBCODE_INVO_OBJ_UNKNOW("903"),
    PLAT_STUBCODE_EST_INVO_OBJ("904"),
    PLAT_STUBCODE_INVO_OBJ_NO_METHOD("905"),
    PLAT_STUBCODE_EST_UNKNOW("906"),

    PLAT_CROSS_SRV_OBJ_NOTFOUND("911"),
    PLAT_CROSS_CALL_EAI_API_ERR("912"),

    FTP_JOB_NOTFOUND("921"),
    FTP_TRANSPORT_FAIL("922"),

    PLAT_NOT_SUPPORT("998"),
    PLAT_UNKNOW("999"),

    /*
     * 註冊類異常
     * 2012-05-09 Lillian Q00-20120322001 新增 host ip 與 wsdl ip 不一致的狀態碼(807)
     * 2012-11-09 Lillian Q00-20121109002 新增ClientOnly產品不可透過WS修改產品資訊的狀態碼(808)
     */
    REG_PROD_EXIST("811"),
    REG_PROD_NOWSDL("801"),
    REG_PROD_PARSEWSDL("802"),
    REG_PROD_LACK_WSDL_METHOD("818"),
    REG_PROD_GEN_WS_CODE("803"),
    REG_PROD_PARSEREST("804"),
    REG_PROD_AUTH_FAIL("881"),
    REG_PROD_IP_INCONSISTENT("807"),
    REG_PROD_CLIENTONLY_CANNOT_MODIFIED("808"),

    REG_AMBIGUOUS_PROD("813"),
    REG_PROD_NOTFOUND("806"),

    REG_SRV_ONE_MORE_FAILED("810"),

    // 整合產品識別規則調整用 2017-05-17 Neville Hsieh
    UPDATE_PROD_UID_MODIFY_FAIL("812"),

    //[S00-20170621001] 整合設定產品註冊錯誤訊息調整  2017-06-28 cherry
    //產品端回傳產品註冊資訊時發生例外
    SRV_RETURNED_PROD_REG_THROW_EXCEPTION("814"),
    //產品端回傳產品註冊訊息錯誤
    SRV_RETURNED_PROD_REG_ERROR_FORMAT("815"),
    //產品端回傳服務註冊資訊時發生例外
    SRV_RETURNED_SRV_REG_THROW_EXCEPTION("816"),
    //產品端回傳服務註冊訊息錯誤
    SRV_RETURNED_SRV_REG_ERROR_FORMAT("817"),

    //B2B-MQ連線測試
    MQ_CONN_FAILED("821"),
    //找到多個產品
    DUPLICATE_PRODUCT_EXCEPTION("822"),
    //缺少syncprod
    REG_PROD_LACK_SYNCPROD("823"),


    //多廠區
    UNION_LOCAL_LACK_EXT_IP("841"),
    UNION_REG_EAI_NOTFOUND("842"),
    UNION_PROD_EXIST("843"),
    UNION_LOCAL_LACK_UID("844"),
    UNION_TENANT_EXISTS("845"),

    UNION_REMOTE_LACK_EXT_IP("8C1"),
    UNION_LOSS_EAI("8C2"),
    UNION_LOCAL_CONN("8C3"),

    //ETL執行
    ETL_RUN_SUCCESS("049"),
    ETL_RUN_FALSE("411"),
    ETL_RUN_TIMEOUT("421"),
    ETL_NO_JOB("401"),
    ETL_NO_JOBVERSION("402"),
    //去中心化調用
    MSG_DECENTRALIZATION_RECEIVED("D00"),
    ;

    public static final Map<String, StateEnum> STATEENUM_CODE_MAP = new HashMap<>();

    static {
        for (StateEnum tEnum : values()) {
            STATEENUM_CODE_MAP.put(tEnum.getCode(), tEnum);
        }
    }

    private final String code;

    StateEnum(String code) {
        this.code = code;
    }

    public String getCode() {
        return code;
    }

    public int getState() {
        switch (this) {
            case MSG_DECENTRALIZATION_RECEIVED:
            case ASYNC_MANUAL_CALLBACK:
                return 0;
            case SYNC_REMOTE_RETURNED_SRV100:
            case UNION_REMOTE_RETURNED_SRV100:
            case ASYNC_CALLBACKED_SRV100:
            case FASYNC_REMOTE_CALLBACKED_SRV100:
            case UNION_FASYNC_REMOTE_CALLBACKED_SRV100:
            case FASYNC_CALLBACKED_SRV100:
            case FASYNC_REMOTE_RETURNED_SRV100:
            case UNION_FASYNC_CALLBACKED_SRV100:
            case UNION_FASYNC_REMOTE_RETURNED_SRV100:
            case UNION_REMOTE_RETURNED_SRV_FAILED:
            case UNION_REMOTE_RETURNED_SRV_FASYNC_FAILED:
                return 2;
            default:
                if (code.startsWith("0")) {
                    return 0;
                } else {
                    return 1;
                }
        }
    }
}
