package com.digiwin.cross.domain.utils;

import com.digiwin.cross.domain.bo.FullAsyncRequestBO;
import com.digiwin.cross.domain.bo.LogBO;
import com.digiwin.cross.domain.bo.LogContent;
import com.digiwin.cross.domain.bo.RequestBO;
import com.digiwin.cross.domain.bo.ResponseBO;
import com.digiwin.cross.domain.common.HeaderNamesConstant;
import com.digiwin.cross.domain.common.OperationConstant;
import com.digiwin.cross.domain.state.StateEnum;
import lombok.extern.apachecommons.CommonsLog;

import java.util.Calendar;
import java.util.Map;

/**
 * @description:
 * @author: clay
 * @date: 2023/6/30
 */
@CommonsLog
public class CallBackLogUtil extends LogUtil {

    public static void beforeCallBackRequester (String restUrl, FullAsyncRequestBO asyncContext, Map<String, String> headers, String body) {
        try {
            int seq = 100;
            LogContent tLogContent = initLog(asyncContext.getReqId(), true, seq);
            tLogContent.setAppId(getAppId(headers));
            tLogContent.setOperation(OperationConstant.CALLBACK);
            tLogContent.setProviderBO(asyncContext.getServiceInfo());
            tLogContent.setReqDataKey(asyncContext.getDataKey());
            if (asyncContext.getRequester().getEai() != null) {
                tLogContent.setReqEaiIp(asyncContext.getRequester().getEai().getIpAddress());
            }
            tLogContent.setRequesterBO(asyncContext.getHostInfo());
            tLogContent.setResDataKey(headers.get(HeaderNamesConstant.DIGI_DATA_KEY));
            tLogContent.setServiceDescription(asyncContext.getProvider().getService().getServiceDescription());
            if (asyncContext.getProvider().getEai() != null) {
                tLogContent.setSrvEaiIp(asyncContext.getProvider().getEai().getIpAddress());
            }
            LogBO tLogBO = new LogBO(tLogContent);
            if (asyncContext.getProvider().isAgile()) {
                if ("000".equals(headers.get(HeaderNamesConstant.DIGI_SRVCODE))) {
                    tLogBO.setStateEnum(StateEnum.FASYNC_REMOTE_CALLBACKED);
                } else {
                    tLogBO.setStateEnum(StateEnum.FASYNC_REMOTE_CALLBACKED_SRV100);
                }
            } else {
                if ("000".equals(headers.get(HeaderNamesConstant.DIGI_SRVCODE))) {
                    tLogBO.setStateEnum(StateEnum.UNION_FASYNC_REMOTE_CALLBACKED);
                } else {
                    tLogBO.setStateEnum(StateEnum.UNION_FASYNC_REMOTE_CALLBACKED_SRV100);
                }
            }
            tLogBO.setPlatformTime(Calendar.getInstance());
            tLogBO.setMessage(convertRestLogMessage(restUrl, headers, body));
            tLogBO.setMessageSize(StringUtil.calcStringSize(body));
            tLogBO.setStepNumber(5);
            saveLog(tLogBO, true);
            alarmBigRes(tLogBO);
        } catch (Exception e) {
            log.error("log error", e);
        }
    }

    public static void callBackRequester (FullAsyncRequestBO context, RequestBO requestBO) {
        try {
            LogContent tLogContent = getLogContent(context.getReqId(), true);
            LogBO tLogBO = new LogBO(tLogContent);
            tLogBO.setMessage(convertRestLogMessage(requestBO.getTargetUrl(), requestBO.getHeaders(), requestBO.getBody()));
            tLogBO.setMessageSize(StringUtil.calcStringSize(requestBO.getBody()));
            tLogBO.setOperation(OperationConstant.CALLBACK);
            if (context.getRequester().isAgile()) {
                tLogBO.setStateEnum(StateEnum.FASYNC_CALLBACK);
            } else {
                tLogBO.setStateEnum(StateEnum.UNION_FASYNC_CALLBACK);
            }
            tLogBO.setPlatformTime(Calendar.getInstance());
            tLogBO.setStepNumber(6);
            saveLog(tLogBO, true);
        } catch (Exception e) {
            log.error("log error", e);
        }
    }

    public static void afterCallBackRequester (FullAsyncRequestBO context, ResponseBO responseBO) {
        try {
            LogContent tLogContent = getLogContent(context.getReqId(), true);
            LogBO tLogBO = new LogBO(tLogContent);
            tLogBO.setMessage(convertRestLogMessage(responseBO.getHeaders(), responseBO.getBody()));
            tLogBO.setMessageSize(StringUtil.calcStringSize(responseBO.getBody()));
            tLogBO.setOperation(OperationConstant.CALLBACK);
            if (context.getRequester().isAgile()) {
                if (responseBO.isBusinessSuccess()) {
                    // STATE: 0EE
                    tLogBO.setStateEnum(StateEnum.FASYNC_CALLBACKED);
                } else {
                    // STATE: 0EF
                    tLogBO.setStateEnum(StateEnum.FASYNC_CALLBACKED_SRV100);
                }
            } else {
                if (responseBO.isBusinessSuccess()) {
                    // STATE: 0EE
                    tLogBO.setStateEnum(StateEnum.UNION_FASYNC_CALLBACKED);
                } else {
                    // STATE: 0EF
                    tLogBO.setStateEnum(StateEnum.UNION_FASYNC_CALLBACKED_SRV100);
                }
            }
            tLogBO.setPlatformTime(Calendar.getInstance());
            tLogBO.setStepNumber(7);
            saveLog(tLogBO, true);
        } catch (Exception e) {
            log.error("log error", e);
        }
    }
}

