package com.digiwin.cross.domain.utils;

import org.apache.commons.codec.binary.Base64;

import java.io.*;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZipUtil {

    public static String compress (byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("data is null or empty");
        }


        byte[] newData;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             GZIPOutputStream gzip = new GZIPOutputStream(baos)) {

            gzip.write(data);
            gzip.finish();
            gzip.flush();
            newData = baos.toByteArray();
        }
        return Base64.encodeBase64String(newData);
    }

    public static String decompress (String pCompressData) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (ByteArrayInputStream tByteArrayInputStream = new ByteArrayInputStream(Base64.decodeBase64(pCompressData));
             GZIPInputStream tGzipInputStream = new GZIPInputStream(tByteArrayInputStream)) {
            BufferedReader br = new BufferedReader(new InputStreamReader(tGzipInputStream, "UTF-8")); // 解壓縮
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        return sb.toString();// 解壓縮成功回傳結果
    }

//    public static void main (String[] args) throws IOException {
//        String s = "{\"std_data\":{\"execution\":{\"sql_code\":\"\",\"code\":\"0\",\"description\":\"\"},\"parameter\":{\"field_info\":[]}}}";
//        String tCompress = compress(s.getBytes(StandardCharsets.UTF_8));
//        System.out.println(tCompress);
//        System.out.println(decompress(tCompress));
//    }
}
