package com.digiwin.cross.domain.utils;

import lombok.extern.apachecommons.CommonsLog;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/7/13 17:48
 */
@CommonsLog
public class StringUtil {

    public static Double calcStringSize(String pMessage) {
        Double tSize = 0D;

        if (StringUtils.isNotBlank(pMessage)) {
            BigDecimal tMgeSize;
            try {
                tMgeSize = BigDecimal.valueOf(pMessage.getBytes("UTF-8").length);
            } catch (Exception e) {
                log.error(e);
                return tSize;
            }
            BigDecimal tDiv = new BigDecimal(1024);
            tSize = tMgeSize.divide(tDiv, 9, BigDecimal.ROUND_HALF_UP).doubleValue();
        }
        return tSize;
    }
}
