package com.digiwin.cross.domain.utils;

import lombok.extern.apachecommons.CommonsLog;

import java.net.MalformedURLException;
import java.net.URL;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/6/7 10:44
 */
@CommonsLog
public class UrlUtil {


    /**
     * 取得RESTful URL的IP位置
     *
     * @param restUrl
     * @return
     */
    public static String getHost(String restUrl) {
        try {
            URL tUrl = new URL(restUrl);
            return tUrl.getHost();
        } catch (MalformedURLException e) {
            log.error("解析restUrl host 异常", e);
            return "";
        }
    }
}
