/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.domain.parameter;

import com.digiwin.cross.domain.parameter.PropertiesKey;
import com.digiwin.cross.domain.utils.SpringContextUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Base64Utils;

public class PropertiesParameter {
    public static void loadParameter(Class<? extends PropertiesParameter> pClass) {
        Log log = LogFactory.getLog(pClass);
        PropertiesParameter.loadProperties(null, pClass, log);
    }

    private static void loadProperties(Properties properties, Class<? extends PropertiesParameter> pClass, Log log) {
        System.out.println(pClass.getDeclaredFields());
        for (Field tField : pClass.getDeclaredFields()) {
            try {
                Class<?> tClass;
                PropertiesKey tKeyAnnotation = tField.getAnnotation(PropertiesKey.class);
                if (null == tKeyAnnotation) {
                    System.out.println(pClass + " field has no PropertiesKey annotation " + tField.getName());
                    continue;
                }
                String tKey = tKeyAnnotation.value();
                boolean tIsBase64 = tKeyAnnotation.isBase64();
                String tValue = SpringContextUtil.getStringProp(tKey);
                log.info((Object)(tField.getName() + "=" + tValue));
                if (!StringUtils.isNotBlank((CharSequence)tValue)) continue;
                tValue = tValue.trim();
                if (tIsBase64) {
                    tValue = new String(Base64Utils.decodeFromString((String)tValue));
                }
                if ((tClass = tField.getType()).equals(String.class)) {
                    tField.set(null, tValue);
                    continue;
                }
                try {
                    Method tMethod = tClass.getMethod("valueOf", String.class);
                    tField.set(null, tMethod.invoke(null, tValue));
                }
                catch (NoSuchMethodException | InvocationTargetException e) {
                    log.warn((Object)("Not support properties type:" + tClass.getName()));
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error((Object)("Load property field:" + tField.getName() + "fail"));
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

