/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.domain.service.validator;

import com.digiwin.cross.domain.exception.JsonValidatorException;
import com.digiwin.cross.domain.exception.ServiceResponseRestFormatException;
import com.digiwin.cross.domain.exception.ValidatorException;
import com.digiwin.cross.domain.service.validator.InvokeResponseBodyJsonValidator;
import com.digiwin.cross.domain.service.validator.RestMessageValidator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class InvokeResponseValidator
extends RestMessageValidator {
    private final String[] requiredHeaderNames = new String[]{"digi-srvcode"};
    private InvokeResponseBodyJsonValidator invokeResponseBodyJsonValidator;

    public InvokeResponseValidator(InvokeResponseBodyJsonValidator invokeResponseBodyJsonValidator) {
        this.invokeResponseBodyJsonValidator = invokeResponseBodyJsonValidator;
    }

    @Override
    protected void validatorHeader(Map<String, String> pHeaders) throws ValidatorException {
        for (String tHeaderName : this.requiredHeaderNames) {
            String tHeaderValue = pHeaders.get(tHeaderName);
            if (!StringUtils.isBlank((CharSequence)tHeaderValue)) continue;
            throw new ServiceResponseRestFormatException(String.format("Missing header: %s", tHeaderName), this.headers, this.body);
        }
    }

    @Override
    protected void validatorBody(String pBody) throws ValidatorException {
        try {
            this.invokeResponseBodyJsonValidator.validate(pBody, "body");
        }
        catch (JsonValidatorException e) {
            throw new ServiceResponseRestFormatException(e.getMessage(), this.headers, this.body);
        }
    }
}

