/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.domain.utils;

import com.digiwin.cross.domain.bo.FullAsyncRequestBO;
import com.digiwin.cross.domain.bo.LogBO;
import com.digiwin.cross.domain.bo.LogContent;
import com.digiwin.cross.domain.bo.RequestBO;
import com.digiwin.cross.domain.bo.ResponseBO;
import com.digiwin.cross.domain.state.StateEnum;
import com.digiwin.cross.domain.utils.LogUtil;
import com.digiwin.cross.domain.utils.StringUtil;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CallBackLogUtil
extends LogUtil {
    private static final Log log = LogFactory.getLog(CallBackLogUtil.class);

    public static void beforeCallBackRequester(String restUrl, FullAsyncRequestBO asyncContext, Map<String, String> headers, String body) {
        try {
            int seq = 100;
            LogContent tLogContent = CallBackLogUtil.initLog(asyncContext.getReqId(), true, seq);
            tLogContent.setAppId(CallBackLogUtil.getAppId(headers));
            tLogContent.setOperation("callback");
            tLogContent.setProviderBO(asyncContext.getServiceInfo());
            tLogContent.setReqDataKey(asyncContext.getDataKey());
            if (asyncContext.getRequester().getEai() != null) {
                tLogContent.setReqEaiIp(asyncContext.getRequester().getEai().getIpAddress());
            }
            tLogContent.setRequesterBO(asyncContext.getHostInfo());
            tLogContent.setResDataKey(headers.get("digi-datakey"));
            tLogContent.setServiceDescription(asyncContext.getProvider().getService().getServiceDescription());
            if (asyncContext.getProvider().getEai() != null) {
                tLogContent.setSrvEaiIp(asyncContext.getProvider().getEai().getIpAddress());
            }
            LogBO tLogBO = new LogBO(tLogContent);
            if (asyncContext.getProvider().isAgile()) {
                if ("000".equals(headers.get("digi-srvcode"))) {
                    tLogBO.setStateEnum(StateEnum.FASYNC_REMOTE_CALLBACKED);
                } else {
                    tLogBO.setStateEnum(StateEnum.FASYNC_REMOTE_CALLBACKED_SRV100);
                }
            } else if ("000".equals(headers.get("digi-srvcode"))) {
                tLogBO.setStateEnum(StateEnum.UNION_FASYNC_REMOTE_CALLBACKED);
            } else {
                tLogBO.setStateEnum(StateEnum.UNION_FASYNC_REMOTE_CALLBACKED_SRV100);
            }
            tLogBO.setPlatformTime(Calendar.getInstance());
            tLogBO.setMessage(CallBackLogUtil.convertRestLogMessage(restUrl, headers, body));
            tLogBO.setMessageSize(StringUtil.calcStringSize(body));
            tLogBO.setStepNumber(5);
            CallBackLogUtil.saveLog(tLogBO, true);
            CallBackLogUtil.alarmBigRes(tLogBO);
        }
        catch (Exception e) {
            log.error((Object)"log error", (Throwable)e);
        }
    }

    public static void callBackRequester(FullAsyncRequestBO context, RequestBO requestBO) {
        try {
            LogContent tLogContent = CallBackLogUtil.getLogContent(context.getReqId(), true);
            LogBO tLogBO = new LogBO(tLogContent);
            tLogBO.setMessage(CallBackLogUtil.convertRestLogMessage(requestBO.getTargetUrl(), requestBO.getHeaders(), requestBO.getBody()));
            tLogBO.setMessageSize(StringUtil.calcStringSize(requestBO.getBody()));
            tLogBO.setOperation("callback");
            if (context.getRequester().isAgile()) {
                tLogBO.setStateEnum(StateEnum.FASYNC_CALLBACK);
            } else {
                tLogBO.setStateEnum(StateEnum.UNION_FASYNC_CALLBACK);
            }
            tLogBO.setPlatformTime(Calendar.getInstance());
            tLogBO.setStepNumber(6);
            CallBackLogUtil.saveLog(tLogBO, true);
        }
        catch (Exception e) {
            log.error((Object)"log error", (Throwable)e);
        }
    }

    public static void afterCallBackRequester(FullAsyncRequestBO context, ResponseBO responseBO) {
        try {
            LogContent tLogContent = CallBackLogUtil.getLogContent(context.getReqId(), true);
            LogBO tLogBO = new LogBO(tLogContent);
            tLogBO.setMessage(CallBackLogUtil.convertRestLogMessage(responseBO.getHeaders(), responseBO.getBody()));
            tLogBO.setMessageSize(StringUtil.calcStringSize(responseBO.getBody()));
            tLogBO.setOperation("callback");
            if (context.getRequester().isAgile()) {
                if (responseBO.isBusinessSuccess()) {
                    tLogBO.setStateEnum(StateEnum.FASYNC_CALLBACKED);
                } else {
                    tLogBO.setStateEnum(StateEnum.FASYNC_CALLBACKED_SRV100);
                }
            } else if (responseBO.isBusinessSuccess()) {
                tLogBO.setStateEnum(StateEnum.UNION_FASYNC_CALLBACKED);
            } else {
                tLogBO.setStateEnum(StateEnum.UNION_FASYNC_CALLBACKED_SRV100);
            }
            tLogBO.setPlatformTime(Calendar.getInstance());
            tLogBO.setStepNumber(7);
            CallBackLogUtil.saveLog(tLogBO, true);
        }
        catch (Exception e) {
            log.error((Object)"log error", (Throwable)e);
        }
    }
}

