/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.domain.utils;

import com.digiwin.cross.domain.common.ProductType;
import com.digiwin.cross.domain.service.IFilterHeaderService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class FilterHeaderUtil
implements ApplicationContextAware {
    private static final String DIGI_HEADER = "digi-";
    private static final String DIGI_CALLBACK_HEADER = "digi-callback";
    private static IFilterHeaderService filterHeaderService;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        filterHeaderService = (IFilterHeaderService)applicationContext.getBean(IFilterHeaderService.class);
    }

    public static Map<String, String> passHeaders(Map<String, String> headers) {
        return headers.entrySet().stream().filter(headerEntry -> {
            String tHeaderName = (String)headerEntry.getKey();
            return !tHeaderName.startsWith(DIGI_CALLBACK_HEADER) && (tHeaderName.startsWith(DIGI_HEADER) || filterHeaderService.getServiceHeaderList().contains(tHeaderName));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map<String, String> passCallbackHeaders(Map<String, String> headers) {
        return headers.entrySet().stream().filter(headerEntry -> {
            String tHeaderName = (String)headerEntry.getKey();
            return tHeaderName.startsWith(DIGI_HEADER) || filterHeaderService.getServiceHeaderList().contains(tHeaderName);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map<String, String> callbackHeaders(Map<String, String> headers) {
        return headers.entrySet().stream().filter(headerEntry -> {
            String tHeaderName = (String)headerEntry.getKey();
            return tHeaderName.startsWith(DIGI_CALLBACK_HEADER) || filterHeaderService.getCallbackHeaderList().contains(tHeaderName);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map<String, String> filterBlockHeaders(Map<String, String> headers, ProductType productType) {
        List<Object> tBlockList;
        switch (productType) {
            case AGILE: {
                tBlockList = filterHeaderService.getBlockAgileHeader();
                break;
            }
            case STANDARD: {
                tBlockList = filterHeaderService.getBlockStandardHeader();
                break;
            }
            default: {
                tBlockList = Collections.emptyList();
            }
        }
        return headers.entrySet().stream().filter(headerEntry -> !tBlockList.contains(headerEntry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

