package com.digiwin.cross.domain;

import com.digiwin.cross.domain.common.BeanNameConstant;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @description:
 * @author: clay
 * @date: 2023/7/13
 */
@Configuration
public class ThreadPoolConfiguration {
    @Value("${logHandler.minActive}")
    private Integer logHandlerMinActive;
    @Value("${logHandler.maxActive}")
    private Integer logHandlerMaxActive;
    @Value("${logHandler.maxBufferSize}")
    private Integer logHandlerMaxBufferSize;

    @Bean(BeanNameConstant.LOG_HANDLER_THREAD_POOL)
    public ThreadPoolExecutor logHandlerExecutor() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(
                logHandlerMinActive,
                logHandlerMaxActive,
                60,
                TimeUnit.SECONDS,
                new ArrayBlockingQueue<>(logHandlerMaxBufferSize),
                new ThreadPoolExecutor.AbortPolicy()
        );

        return executor;
    }

}
