package com.digiwin.cross.domain.bo;

import com.digiwin.cross.domain.service.validator.bo.ProviderBO;
import com.digiwin.cross.domain.service.validator.bo.RequesterBO;
import com.digiwin.cross.domain.state.StateEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.extern.apachecommons.CommonsLog;
import org.apache.commons.lang3.StringUtils;
import sun.rmi.runtime.Log;

import java.text.MessageFormat;
import java.util.Calendar;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/6/20 15:42
 */
@Getter
@Setter
@CommonsLog
public class LogBO {

    private String reqId;

    private String reqDataKey;

    private String resDataKey;

    private Integer logDisplayPriority;

    private RequesterInfoBO requesterBO;

    private ProviderInfoBO providerBO;

    private String serviceDescription;

    private String operation;

    private String reqEaiIp;

    private String srvEaiIp;

    private String appId;

    private StateEnum stateEnum;

    private Calendar platformTime;

    private byte[] message;

    private byte[] responseMessage;

    private MessageFormat msgType = MessageFormat.JSON;

    private Double messageSize;

    private Integer stepNumber;

    /**
     * add by songwq
     * 传给mmc时需要新增当前字段
     */
    private String pinpointId;

    public LogBO() {
    }

    public LogBO(LogContent logContent) {
        this.reqId = logContent.getReqId();

        this.reqDataKey = logContent.getReqDataKey();

        this.resDataKey = logContent.getResDataKey();

        this.requesterBO = logContent.getRequesterBO();

        this.providerBO = logContent.getProviderBO();

        this.serviceDescription = logContent.getServiceDescription();

        this.operation = logContent.getOperation();

        this.reqEaiIp = logContent.getReqEaiIp();

        this.srvEaiIp = logContent.getSrvEaiIp();

        this.appId = logContent.getAppId();

    }

    public enum MessageFormat {
        JSON
    }
}
