package com.digiwin.cross.domain.convertor;

import com.digiwin.cross.domain.bo.FullAsyncRequestBO;
import com.digiwin.cross.domain.bo.RequestBO;
import com.digiwin.cross.domain.bo.ResponseBO;
import com.digiwin.cross.domain.bo.ServiceRequestBO;
import com.digiwin.cross.domain.bo.ServiceResponseBO;
import com.digiwin.cross.domain.bo.entity.EaiEntity;
import com.digiwin.cross.domain.common.HeaderNamesConstant;
import com.digiwin.cross.domain.common.ProductType;
import com.digiwin.cross.domain.utils.DigestUtil;
import com.digiwin.cross.domain.utils.FilterHeaderUtil;
import com.digiwin.cross.domain.utils.JsonUtil;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * @description:
 * @author: clay
 * @date: 2023/6/26
 */
public class InvokeConvertor {

    public static RequestBO convertToRequestBO(ServiceRequestBO pServiceRequestBO) {
        RequestBO tRequestBO = new RequestBO();
        tRequestBO.setReqId(pServiceRequestBO.getReqId());
        tRequestBO.setPathParam(pServiceRequestBO.getPathParam());
        tRequestBO.setQueryParams(pServiceRequestBO.getQueryParams());

        String tHostInfoStr = JsonUtil.toJson(pServiceRequestBO.getHostInfo());
        String tServiceInfoStr = JsonUtil.toJson(pServiceRequestBO.getServiceInfo());
        String tKey = DigestUtil.getDigestCode("MD5", tHostInfoStr + tServiceInfoStr);

        Map<String, String> tHeaders = new HashMap<>();
        tHeaders.put(HeaderNamesConstant.DIGI_REQID, pServiceRequestBO.getReqId());
        tHeaders.put(HeaderNamesConstant.DIGI_TYPE, pServiceRequestBO.getRequestType().toString().toLowerCase());
        if (pServiceRequestBO.getDataKey() != null) {
            tHeaders.put(HeaderNamesConstant.DIGI_DATA_KEY, pServiceRequestBO.getDataKey());
        }
        tHeaders.put(HeaderNamesConstant.DIGI_HOST, tHostInfoStr);
        tHeaders.put(HeaderNamesConstant.DIGI_SERVICE, tServiceInfoStr);
        if (pServiceRequestBO.getProvider().getProductType() == ProductType.STANDARD) {
            tHeaders.put(HeaderNamesConstant.DIGI_KEY, tKey);
        }
        tHeaders.putAll(pServiceRequestBO.getDigiHeaders());

        tRequestBO.setHeaders(tHeaders);
        tRequestBO.setBody(pServiceRequestBO.getBody());

        switch (pServiceRequestBO.getProvider().getProductType()) {
            case AGILE:
                tRequestBO.setTargetUrl(pServiceRequestBO.getProvider().getProduct().getRestUrl());
                break;
            case STANDARD:
                EaiEntity tEaiEntity = pServiceRequestBO.getProvider().getEai();
                tRequestBO.setTargetLongConnId(tEaiEntity.getLongConnId());
                tRequestBO.setTargetGatewayId(tEaiEntity.getGatewayId());
                break;
        }

        return tRequestBO;
    }

    public static ServiceResponseBO convertToServiceResponseBO(ResponseBO pResponseBO) {
        ServiceResponseBO tServiceResponseBO = new ServiceResponseBO();

        //透傳header
        Map<String, String> tPassHeaders = FilterHeaderUtil.passCallbackHeaders(pResponseBO.getHeaders());
        tPassHeaders.forEach((headerName, headerValue) -> {
            switch (headerName) {
                case HeaderNamesConstant.DIGI_SRVCODE:
                    tServiceResponseBO.setSrvCode(headerValue);
                    tServiceResponseBO.getHeaders().put(headerName, headerValue);
                    break;
                case HeaderNamesConstant.DIGI_SRVVER:
                    tServiceResponseBO.setSrvVer(headerValue);
                    tServiceResponseBO.getHeaders().put(headerName, headerValue);
                    break;
                case HeaderNamesConstant.DIGI_DATA_KEY:
                    tServiceResponseBO.setDataKey(headerValue);
                    tServiceResponseBO.getHeaders().put(headerName, headerValue);
                    break;
                case HeaderNamesConstant.DIGI_CODE:
                    tServiceResponseBO.setCode(headerValue);
                    tServiceResponseBO.setEaiSuccess(StringUtils.startsWith(headerValue,"0"));
                    break;
                case HeaderNamesConstant.DIGI_MESSAGE:
                    break;
                case HeaderNamesConstant.DIGI_REQID:
                    tServiceResponseBO.setReqId(headerValue);
                    break;
                default:
                    tServiceResponseBO.getHeaders().put(headerName, headerValue);
                    break;
            }
        });

        tServiceResponseBO.setBody(pResponseBO.getBody());
        return tServiceResponseBO;
    }

    public static FullAsyncRequestBO convertToFullAsyncRequest(ServiceRequestBO request) {
        FullAsyncRequestBO tFullAsyncRequestBO = new FullAsyncRequestBO();
        tFullAsyncRequestBO.setReqId(request.getReqId());
        tFullAsyncRequestBO.setDispatchId(request.getDispatchId());
        tFullAsyncRequestBO.setDataKey(request.getDataKey());
        tFullAsyncRequestBO.setCallbackHeaders(request.getCallbackHeaders());
        tFullAsyncRequestBO.setHostInfo(request.getHostInfo());
        tFullAsyncRequestBO.setServiceInfo(request.getServiceInfo());
        tFullAsyncRequestBO.setRequester(request.getRequester());
        tFullAsyncRequestBO.setProvider(request.getProvider());
        tFullAsyncRequestBO.setPinpointId(request.getPinpointId());
        return tFullAsyncRequestBO;
    }
}
