package com.digiwin.cross.domain.exception;


import com.digiwin.cross.domain.state.StateEnum;

/**
 * @description:
 * @author: clay
 * @date: 2023/6/1
 */
public abstract class BaseException extends Exception {
    protected StateEnum stateEnum;

    public BaseException(StateEnum stateEnum) {
        this.stateEnum = stateEnum;
    }

    public BaseException(StateEnum stateEnum, String errorMessage) {
        super(errorMessage);
        this.stateEnum = stateEnum;
    }

    public BaseException(StateEnum stateEnum, Throwable e) {
        super(e);
        this.stateEnum = stateEnum;
    }

    public StateEnum getStateEnum() {
        return stateEnum;
    }

    public String getStateCode() {
        if (null == stateEnum) {
            return null;
        }
        return stateEnum.getCode();
    }

    public String getErrorStatus() {
        return null;
    }
}
