package com.digiwin.cross.domain.gateway;

import com.digiwin.cross.domain.bo.EaiBO;
import com.digiwin.cross.domain.bo.entity.EaiEntity;
import com.digiwin.cross.domain.bo.entity.EaiTenantEntity;
import com.digiwin.cross.domain.state.StateEnum;

import java.util.List;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/6/13 14:10
 */

public interface IEaiGateway {

    EaiEntity queryEai(String eaiUid);

    EaiEntity queryEai(Long id);

    EaiBO queryEaiWithUnionProductByTenantId(String tenantId);

    void addEai(EaiBO eaiBO);

    void updateEai(EaiBO eaiBO);

    void updateEaiStatus(Long id, StateEnum stateEnum);

    void deleteEai(EaiEntity eaiBO);

    EaiEntity getEaiInCache(String eaiUid);

    void saveEaiCache(EaiEntity eaiEntity);

    void saveEaiCache(EaiBO eaiBO, String tenantId);

    EaiEntity getEaiInCacheByTenantId(String tenantId);

    EaiEntity getEaiByTenantId(String tenantId);

    List<EaiTenantEntity> queryOtherEaiTenantByTenantIds(List<String> tenantIds, String eaiUid);
}
