package com.digiwin.cross.domain.parameter;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

/**
 * @description:
 * @author: clay
 * @date: 2023/6/19
 */
@Component
@PropertiesFile("saas.properties")
public class SaasParameter extends PropertiesParameter implements InitializingBean{

    @PropertiesKey("mq.use.ssl")
    public static Boolean MQ_USE_SSL;
    @PropertiesKey("mq.protocol")
    public static String MQ_PROTOCOL;
    @PropertiesKey("mq.host")
    public static String MQ_HOST;
    @PropertiesKey("mq.port.amqp")
    public static Integer MQ_PORT_AMQP;
    @PropertiesKey("mq.port.amqp.ssl")
    public static Integer MQ_PORT_AMQP_SSL;
    @PropertiesKey("mq.port.http")
    public static Integer MQ_PORT_HTTP;
    @PropertiesKey("mq.user")
    public static String MQ_USER;
    @PropertiesKey(value = "mq.password")
    public static String MQ_PASSWORD;
    @PropertiesKey("mq.mqp.host")
    public static String MQP_HOST;
    @PropertiesKey("saas.tenant.id")
    public static String SAAS_TENANT_ID;
    @PropertiesKey("saas.gateway.id")
    public static String SAAS_GATEWAY_ID;
    @PropertiesKey("saas.gateway.name")
    public static String SAAS_GATEWAY_NAME;

    private static Boolean loaded=false;
    @Override
    public void afterPropertiesSet() throws Exception {
        load();
    }

    public static void load(){
        if(!loaded){
            loadParameter(SaasParameter.class);
            loaded=true;
        }
    }
}
