package com.digiwin.cross.domain.state;

import com.digiwin.cross.domain.bo.StateCodeBO;
import com.digiwin.cross.domain.gateway.IStateCodeGateway;
import com.digiwin.cross.domain.parameter.ApplicationSystemParameter;
import com.digiwin.cross.domain.utils.Base64Util;
import lombok.extern.apachecommons.CommonsLog;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;

/**
 * @description:
 * @author: clay
 * @date: 2023/6/1
 */
@CommonsLog
@Component
public class StateMessageUtil implements ApplicationContextAware {

    private static IStateCodeGateway stateCodeGateway;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        stateCodeGateway = applicationContext.getBean(IStateCodeGateway.class);
        log.info("StateMessageUtil: stateCodeGateway initialized.");
    }

    public static String getStateCodeMessage(StateEnum pStateEnum) {
        return getStateCodeMessage(pStateEnum, ApplicationSystemParameter.MESSAGE_LANGUAGE);
    }

    public static String getStateCodeMessage(StateEnum pStateEnum, String pLang) {
        String tLang = StringUtils.defaultString(pLang, ApplicationSystemParameter.MESSAGE_LANGUAGE);

        String tReturn = "";
        tLang = tLang.replace("-", "_").toLowerCase();
        StateCodeBO tStateCode = stateCodeGateway.getStateCode(pStateEnum.getCode());
        if (tStateCode != null) {
            if (tLang.equals(Locale.TAIWAN.toString().toLowerCase())) {
                tReturn = tStateCode.getCht();
            } else if (tLang.equals(Locale.CHINA.toString().toLowerCase())) {
                tReturn = tStateCode.getChs();
            } else {
                tReturn = tStateCode.getEng();
            }
        }
        return tReturn;
    }

    public static String getBase64StateCodeMessage(StateEnum pStateEnum, String lang) {
        String message = getStateCodeMessage(pStateEnum, lang);
        try {
            return Base64Util.encodeString(message, StandardCharsets.UTF_8.name());
        } catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), e);
            return message;
        }
    }

    public static void initTest(IStateCodeGateway gateway) {
        stateCodeGateway = gateway;
    }
}
