package com.digiwin.cross.domain.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * Digest Utility
 *
 * @author Cloude
 * @since 2010-05-14
 */
public class DigestUtil {
    protected static Log LOG = LogFactory.getLog(DigestUtil.class);

    /**
     * 根據Hash的類型取得Digest的String
     *
     * @param pHashType
     * @param pSrcStr
     * @return
     */
    public static String getDigestCode(String pHashType, String pSrcStr) {
        try {
            MessageDigest obj = MessageDigest.getInstance(pHashType);
            obj.update(pSrcStr.getBytes("UTF-8"));
            byte[] digest = obj.digest();

            StringBuilder buffer = new StringBuilder();
            for (byte b : digest) {
                buffer.append(String.format("%02x", b & 0xFF)); // Ensures each byte is two hexadecimal characters
            }
            return buffer.toString();
        } catch (Exception e) {
            LOG.error(e.getMessage());
        }
        return "";
    }
}
