package com.digiwin.cross.domain.utils;

import com.digiwin.cross.domain.common.ProductType;
import com.digiwin.cross.domain.service.IFilterHeaderService;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @description:
 * @author: clay
 * @date: 2023/6/28
 */
@Component
public class FilterHeaderUtil implements ApplicationContextAware {

    private final static String DIGI_HEADER = "digi-";
    private final static String DIGI_CALLBACK_HEADER = "digi-callback";

    private static IFilterHeaderService filterHeaderService;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        filterHeaderService = applicationContext.getBean(IFilterHeaderService.class);
    }

    public static Map<String, String> passHeaders(Map<String, String> headers) {
        return headers.entrySet().stream()
                .filter(headerEntry -> {
                    String tHeaderName = headerEntry.getKey();
                    return !tHeaderName.startsWith(DIGI_CALLBACK_HEADER)
                            && (tHeaderName.startsWith(DIGI_HEADER) || filterHeaderService.getServiceHeaderList().contains(tHeaderName));
                })
                .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));

    }

    public static Map<String, String> passCallbackHeaders(Map<String, String> headers) {
        return headers.entrySet().stream()
                .filter(headerEntry -> {
                    String tHeaderName = headerEntry.getKey();
                    return tHeaderName.startsWith(DIGI_HEADER) || filterHeaderService.getServiceHeaderList().contains(tHeaderName);
                })
                .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));

    }

    public static Map<String, String> callbackHeaders(Map<String, String> headers) {
        return headers.entrySet().stream()
                .filter(headerEntry -> {
                    String tHeaderName = headerEntry.getKey();
                    return tHeaderName.startsWith(DIGI_CALLBACK_HEADER) || filterHeaderService.getCallbackHeaderList().contains(tHeaderName);
                })
                .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map<String, String> filterBlockHeaders(Map<String, String> headers, ProductType productType) {
        List<String> tBlockList;
        switch (productType) {
            case AGILE:
                tBlockList = filterHeaderService.getBlockAgileHeader();
                break;
            case STANDARD:
                tBlockList = filterHeaderService.getBlockStandardHeader();
                break;
            default:
                tBlockList = Collections.emptyList();
        }

        return headers.entrySet().stream()
                .filter(
                        headerEntry -> !tBlockList.contains(headerEntry.getKey())
                )
                .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));

    }
}
