/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.domain.convertor;

import com.digiwin.cross.domain.bo.FullAsyncRequestBO;
import com.digiwin.cross.domain.bo.RequestBO;
import com.digiwin.cross.domain.bo.ResponseBO;
import com.digiwin.cross.domain.bo.ServiceRequestBO;
import com.digiwin.cross.domain.bo.ServiceResponseBO;
import com.digiwin.cross.domain.bo.entity.EaiEntity;
import com.digiwin.cross.domain.common.ProductType;
import com.digiwin.cross.domain.utils.DigestUtil;
import com.digiwin.cross.domain.utils.FilterHeaderUtil;
import com.digiwin.cross.domain.utils.JsonUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class InvokeConvertor {
    public static RequestBO convertToRequestBO(ServiceRequestBO pServiceRequestBO) {
        RequestBO tRequestBO = new RequestBO();
        tRequestBO.setReqId(pServiceRequestBO.getReqId());
        tRequestBO.setPathParam(pServiceRequestBO.getPathParam());
        tRequestBO.setQueryParams(pServiceRequestBO.getQueryParams());
        String tHostInfoStr = JsonUtil.toJson(pServiceRequestBO.getHostInfo());
        String tServiceInfoStr = JsonUtil.toJson(pServiceRequestBO.getServiceInfo());
        String tKey = DigestUtil.getDigestCode("MD5", tHostInfoStr + tServiceInfoStr);
        HashMap<String, String> tHeaders = new HashMap<String, String>();
        tHeaders.put("digi-reqid", pServiceRequestBO.getReqId());
        tHeaders.put("digi-type", pServiceRequestBO.getRequestType().toString().toLowerCase());
        if (pServiceRequestBO.getDataKey() != null) {
            tHeaders.put("digi-datakey", pServiceRequestBO.getDataKey());
        }
        tHeaders.put("digi-host", tHostInfoStr);
        tHeaders.put("digi-service", tServiceInfoStr);
        if (pServiceRequestBO.getProvider().getProductType() == ProductType.STANDARD) {
            tHeaders.put("digi-key", tKey);
        }
        tHeaders.putAll(pServiceRequestBO.getDigiHeaders());
        tRequestBO.setHeaders(tHeaders);
        tRequestBO.setBody(pServiceRequestBO.getBody());
        switch (pServiceRequestBO.getProvider().getProductType()) {
            case AGILE: {
                tRequestBO.setTargetUrl(pServiceRequestBO.getProvider().getProduct().getRestUrl());
                break;
            }
            case STANDARD: {
                EaiEntity tEaiEntity = pServiceRequestBO.getProvider().getEai();
                tRequestBO.setTargetLongConnId(tEaiEntity.getLongConnId());
                tRequestBO.setTargetGatewayId(tEaiEntity.getGatewayId());
            }
        }
        return tRequestBO;
    }

    public static ServiceResponseBO convertToServiceResponseBO(ResponseBO pResponseBO) {
        ServiceResponseBO tServiceResponseBO = new ServiceResponseBO();
        Map<String, String> tPassHeaders = FilterHeaderUtil.passCallbackHeaders(pResponseBO.getHeaders());
        tPassHeaders.forEach((headerName, headerValue) -> {
            switch (headerName) {
                case "digi-srvcode": {
                    tServiceResponseBO.setSrvCode((String)headerValue);
                    tServiceResponseBO.getHeaders().put((String)headerName, (String)headerValue);
                    break;
                }
                case "digi-srvver": {
                    tServiceResponseBO.setSrvVer((String)headerValue);
                    tServiceResponseBO.getHeaders().put((String)headerName, (String)headerValue);
                    break;
                }
                case "digi-datakey": {
                    tServiceResponseBO.setDataKey((String)headerValue);
                    tServiceResponseBO.getHeaders().put((String)headerName, (String)headerValue);
                    break;
                }
                case "digi-code": {
                    tServiceResponseBO.setCode((String)headerValue);
                    tServiceResponseBO.setEaiSuccess(StringUtils.startsWith((CharSequence)headerValue, (CharSequence)"0"));
                    break;
                }
                case "digi-message": {
                    break;
                }
                case "digi-reqid": {
                    tServiceResponseBO.setReqId((String)headerValue);
                    break;
                }
                default: {
                    tServiceResponseBO.getHeaders().put((String)headerName, (String)headerValue);
                }
            }
        });
        tServiceResponseBO.setBody(pResponseBO.getBody());
        return tServiceResponseBO;
    }

    public static FullAsyncRequestBO convertToFullAsyncRequest(ServiceRequestBO request) {
        FullAsyncRequestBO tFullAsyncRequestBO = new FullAsyncRequestBO();
        tFullAsyncRequestBO.setReqId(request.getReqId());
        tFullAsyncRequestBO.setDispatchId(request.getDispatchId());
        tFullAsyncRequestBO.setDataKey(request.getDataKey());
        tFullAsyncRequestBO.setCallbackHeaders(request.getCallbackHeaders());
        tFullAsyncRequestBO.setHostInfo(request.getHostInfo());
        tFullAsyncRequestBO.setServiceInfo(request.getServiceInfo());
        tFullAsyncRequestBO.setRequester(request.getRequester());
        tFullAsyncRequestBO.setProvider(request.getProvider());
        tFullAsyncRequestBO.setPinpointId(request.getPinpointId());
        return tFullAsyncRequestBO;
    }
}

