/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.domain.service.impl;

import com.digiwin.cross.domain.bo.CallResponseBO;
import com.digiwin.cross.domain.bo.FullAsyncRequestBO;
import com.digiwin.cross.domain.bo.RequestBO;
import com.digiwin.cross.domain.bo.ResponseBO;
import com.digiwin.cross.domain.bo.ServiceResponseBO;
import com.digiwin.cross.domain.bo.entity.EaiEntity;
import com.digiwin.cross.domain.common.ProductType;
import com.digiwin.cross.domain.exception.BaseException;
import com.digiwin.cross.domain.gateway.IInvokeGateway;
import com.digiwin.cross.domain.parameter.ApplicationSystemParameter;
import com.digiwin.cross.domain.service.ICallbackService;
import com.digiwin.cross.domain.state.StateEnum;
import com.digiwin.cross.domain.state.StateMessageUtil;
import com.digiwin.cross.domain.utils.CallBackLogUtil;
import com.digiwin.cross.domain.utils.FilterHeaderUtil;
import java.util.HashMap;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CallBackService
implements ICallbackService {
    private final IInvokeGateway invokeGateway;

    public CallBackService(IInvokeGateway invokeGateway) {
        this.invokeGateway = invokeGateway;
    }

    @Override
    public CallResponseBO call(FullAsyncRequestBO context, ServiceResponseBO serviceResponseBO) throws BaseException {
        StateEnum stateEnum;
        ResponseBO response;
        RequestBO requestBO = this.buildInvokerRequestBO(serviceResponseBO, context);
        CallBackLogUtil.callBackRequester(context, requestBO);
        if (context.getRequester().isAgile()) {
            response = this.invokeGateway.callProduct(requestBO);
            stateEnum = context.getProvider().isAgile() ? StateEnum.FASYNC_CALLBACK_RESULT : StateEnum.UNION_FASYNC_CALLBACK_RESULT;
        } else {
            response = this.invokeGateway.callEai(requestBO);
            stateEnum = response.isEaiSuccess() ? (context.getProvider().isAgile() ? StateEnum.FASYNC_CALLBACK_RESULT : StateEnum.UNION_FASYNC_CALLBACK_RESULT) : (null == (stateEnum = StateEnum.STATEENUM_CODE_MAP.get(response.getHeaders().get("digi-code"))) ? StateEnum.UNION_REMOTE_RETURNED_SRV_FASYNC_FAILED : stateEnum);
        }
        CallBackLogUtil.afterCallBackRequester(context, response);
        return new CallResponseBO(response, stateEnum, context.getHostInfo().getLang());
    }

    private RequestBO buildInvokerRequestBO(ServiceResponseBO serviceResponseBO, FullAsyncRequestBO context) {
        StateEnum state;
        RequestBO tRequestBO = new RequestBO();
        tRequestBO.setOperation("callback");
        tRequestBO.setReqId(serviceResponseBO.getReqId());
        HashMap<String, String> tHeaders = new HashMap<String, String>();
        if (MapUtils.isNotEmpty(context.getCallbackHeaders())) {
            tHeaders.putAll(context.getCallbackHeaders());
        }
        tHeaders.putAll(serviceResponseBO.getHeaders());
        tHeaders.put("digi-reqid", serviceResponseBO.getReqId());
        ProductType productType = context.getRequester().isAgile() ? ProductType.AGILE : ProductType.STANDARD;
        FilterHeaderUtil.filterBlockHeaders(tHeaders, productType);
        tRequestBO.setHeaders(tHeaders);
        tRequestBO.setBody(serviceResponseBO.getBody());
        if (context.getRequester().isAgile()) {
            state = StateEnum.FASYNC_CALLBACK;
            String targetRestUrl = context.getRequester().getProduct().getRestUrl();
            targetRestUrl = CallBackService.concatCallBackUrl(targetRestUrl);
            if (StringUtils.isNotBlank((CharSequence)context.getDispatchId())) {
                tHeaders.put("dispatchid", context.getDispatchId());
                tHeaders.put("callbackurl", targetRestUrl);
                String dispatchUrl = CallBackService.concatCallBackUrl(ApplicationSystemParameter.ESPDP_URL);
                tRequestBO.setTargetUrl(dispatchUrl);
            } else {
                tRequestBO.setTargetUrl(targetRestUrl);
            }
        } else {
            state = StateEnum.UNION_FASYNC_CALLBACK;
            EaiEntity tEaiEntity = context.getRequester().getEai();
            tRequestBO.setTargetLongConnId(tEaiEntity.getLongConnId());
            tRequestBO.setTargetGatewayId(tEaiEntity.getGatewayId());
        }
        tHeaders.put("digi-code", state.getCode());
        tHeaders.put("digi-message", StateMessageUtil.getBase64StateCodeMessage(state, context.getHostInfo().getLang()));
        return tRequestBO;
    }

    private static String concatCallBackUrl(String url) {
        return url + (url.endsWith("/") ? "callback" : "/callback");
    }
}

