/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.domain.service.impl;

import com.digiwin.cross.domain.bo.FullAsyncRequestBO;
import com.digiwin.cross.domain.bo.RequestBO;
import com.digiwin.cross.domain.bo.ResponseBO;
import com.digiwin.cross.domain.bo.ServiceRequestBO;
import com.digiwin.cross.domain.bo.ServiceResponseBO;
import com.digiwin.cross.domain.common.ProductType;
import com.digiwin.cross.domain.common.RequestType;
import com.digiwin.cross.domain.convertor.InvokeConvertor;
import com.digiwin.cross.domain.gateway.IFullAsyncRequestGateway;
import com.digiwin.cross.domain.gateway.IInvokeGateway;
import com.digiwin.cross.domain.gateway.ILockGateway;
import com.digiwin.cross.domain.service.IInvokeService;
import com.digiwin.cross.domain.service.validator.InvokeResponseValidator;
import com.digiwin.cross.domain.utils.InvokeLogUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InvokeService
implements IInvokeService {
    private static final Log log = LogFactory.getLog(InvokeService.class);
    private static final String SUCCESS_SRV_CODE = "000";
    @Autowired
    private IInvokeGateway invokeGateway;
    @Autowired
    private IFullAsyncRequestGateway fullAsyncRequestGateway;
    @Autowired
    private InvokeResponseValidator responseValidator;
    @Autowired
    private ILockGateway lockGateway;

    @Override
    public ServiceResponseBO execute(ServiceRequestBO pServiceRequestBO) throws Exception {
        String tSrvCode;
        ResponseBO tResponse;
        String tReqId = pServiceRequestBO.getReqId();
        RequestType tRequestType = pServiceRequestBO.getRequestType();
        ProductType tProductType = pServiceRequestBO.getProvider().getProductType();
        RequestBO tRequest = InvokeConvertor.convertToRequestBO(pServiceRequestBO);
        String tCode = null;
        boolean fasyncLocked = false;
        if (pServiceRequestBO.getRequestType() == RequestType.FASYNC) {
            // empty if block
        }
        InvokeLogUtil.providerReq(pServiceRequestBO, tRequest);
        switch (pServiceRequestBO.getProvider().getProductType()) {
            case AGILE: {
                tResponse = this.invokeGateway.callProduct(tRequest);
                this.responseValidator.validator(tResponse.getHeaders(), tResponse.getBody());
                tSrvCode = tResponse.getHeaders().get("digi-srvcode");
                break;
            }
            case STANDARD: {
                tResponse = this.invokeGateway.callEai(tRequest);
                tCode = tResponse.getHeaders().get("digi-code");
                tSrvCode = tResponse.getHeaders().get("digi-srvcode");
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)pServiceRequestBO.getProvider().getProductType()));
            }
        }
        InvokeLogUtil.responseRes(tReqId, tResponse, tCode, SUCCESS_SRV_CODE.equals(tSrvCode), tRequestType, tProductType);
        ServiceResponseBO tServiceResponseBO = InvokeConvertor.convertToServiceResponseBO(tResponse);
        pServiceRequestBO.setPinpointId(ThreadContext.get((String)"PtxId"));
        if (pServiceRequestBO.getRequestType() == RequestType.FASYNC && SUCCESS_SRV_CODE.equals(tServiceResponseBO.getSrvCode())) {
            FullAsyncRequestBO fullAsyncRequestBO = InvokeConvertor.convertToFullAsyncRequest(pServiceRequestBO);
            this.fullAsyncRequestGateway.saveFullAsyncRequestInfo(fullAsyncRequestBO);
        }
        return tServiceResponseBO;
    }
}

