/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.domain.service.validator;

import com.digiwin.cross.domain.bo.EaiBO;
import com.digiwin.cross.domain.bo.ProductBO;
import com.digiwin.cross.domain.bo.ProviderInfoBO;
import com.digiwin.cross.domain.bo.RequesterInfoBO;
import com.digiwin.cross.domain.bo.entity.EaiEntity;
import com.digiwin.cross.domain.bo.entity.ProductEntity;
import com.digiwin.cross.domain.bo.entity.ServiceEntity;
import com.digiwin.cross.domain.exception.BaseException;
import com.digiwin.cross.domain.exception.DuplicateProductException;
import com.digiwin.cross.domain.gateway.IEaiGateway;
import com.digiwin.cross.domain.gateway.IProductQueryGateWay;
import com.digiwin.cross.domain.gateway.IServiceQueryGateway;
import com.digiwin.cross.domain.service.validator.bo.ProviderBO;
import com.digiwin.cross.domain.service.validator.bo.RequesterBO;
import com.digiwin.cross.domain.service.validator.exception.CrossRequesterNotFoundException;
import com.digiwin.cross.domain.service.validator.exception.RequesterProductNotFoundException;
import com.digiwin.cross.domain.service.validator.exception.ServiceNameNotFoundException;
import com.digiwin.cross.domain.service.validator.exception.ServiceProviderNotFoundException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ProductValidator {
    private IProductQueryGateWay productQueryGateWay;
    private IServiceQueryGateway serviceQueryGateway;
    private IEaiGateway eaiGateway;

    public ProductValidator(IProductQueryGateWay productQueryGateWay, IServiceQueryGateway serviceQueryGateway, IEaiGateway eaiGateway) {
        this.productQueryGateWay = productQueryGateWay;
        this.serviceQueryGateway = serviceQueryGateway;
        this.eaiGateway = eaiGateway;
    }

    public RequesterBO validateRequester(RequesterInfoBO pRequesterInfoBO) throws BaseException {
        RequesterBO tRequesterBO = new RequesterBO();
        if (pRequesterInfoBO.getEaiUid() == null) {
            ProductEntity tProductEntity = this.validateRequesterProduct(pRequesterInfoBO);
            if (tProductEntity == null) {
                throw new RequesterProductNotFoundException();
            }
            tRequesterBO.setProduct(tProductEntity);
        } else {
            EaiEntity tEaiEntity = this.validateRequesterEai(pRequesterInfoBO.getEaiUid());
            if (tEaiEntity == null) {
                throw new CrossRequesterNotFoundException();
            }
            tRequesterBO.setEai(tEaiEntity);
        }
        return tRequesterBO;
    }

    private ProductEntity validateRequesterProduct(RequesterInfoBO pRequesterInfo) {
        List tClientOnlyProductEntityList;
        List<ProductEntity> tProductEntityList;
        ProductEntity tSelectedProduct = this.productQueryGateWay.findProductInCache(pRequesterInfo.getProd(), pRequesterInfo.getIp(), pRequesterInfo.getId(), pRequesterInfo.getUid());
        if (tSelectedProduct == null && (tSelectedProduct = this.productQueryGateWay.findProductInDB(pRequesterInfo.getProd(), pRequesterInfo.getIp(), pRequesterInfo.getId(), pRequesterInfo.getUid())) != null) {
            this.productQueryGateWay.saveProductCache(tSelectedProduct);
        }
        if (tSelectedProduct == null && CollectionUtils.isNotEmpty(tProductEntityList = this.productQueryGateWay.findProductInCache(pRequesterInfo.getProd())) && CollectionUtils.isNotEmpty(tClientOnlyProductEntityList = tProductEntityList.stream().filter(ProductEntity::getClientOnly).collect(Collectors.toList()))) {
            tSelectedProduct = (ProductEntity)tClientOnlyProductEntityList.get(0);
        }
        if (tSelectedProduct == null) {
            tProductEntityList = this.productQueryGateWay.findProductInDB(pRequesterInfo.getProd());
            if (CollectionUtils.isNotEmpty(tProductEntityList) && CollectionUtils.isNotEmpty(tClientOnlyProductEntityList = tProductEntityList.stream().filter(ProductEntity::getClientOnly).collect(Collectors.toList()))) {
                tSelectedProduct = (ProductEntity)tClientOnlyProductEntityList.get(0);
            }
            if (tSelectedProduct != null) {
                this.productQueryGateWay.saveProductCache(tSelectedProduct);
            }
        }
        return tSelectedProduct;
    }

    private EaiEntity validateRequesterEai(String pEaiUid) {
        EaiEntity tSelectedEai = this.eaiGateway.getEaiInCache(pEaiUid);
        if (tSelectedEai == null && (tSelectedEai = this.eaiGateway.queryEai(pEaiUid)) != null) {
            this.eaiGateway.saveEaiCache(tSelectedEai);
        }
        return tSelectedEai;
    }

    public ProviderBO validateProvider(ProviderInfoBO pProviderInfoBO) throws BaseException {
        ProductBO productBO;
        EaiBO tEaiBO;
        ProductEntity productEntity;
        ProductEntity productEntity2;
        EaiEntity eaiEntity;
        ProviderBO tProviderBO = new ProviderBO();
        boolean hasUnionInfo = StringUtils.isNotBlank((CharSequence)pProviderInfoBO.getTenantId()) && StringUtils.isNotBlank((CharSequence)pProviderInfoBO.getUid());
        boolean foundProvider = false;
        if (hasUnionInfo && (eaiEntity = this.queryProviderEaiInCache(pProviderInfoBO.getTenantId())) != null && (productEntity2 = this.queryProviderUnionProductInCache(pProviderInfoBO, eaiEntity.getUid())) != null) {
            tProviderBO.setProduct(productEntity2);
            tProviderBO.setEai(eaiEntity);
            foundProvider = true;
        }
        if (!foundProvider && (productEntity = this.queryProviderProductInCache(pProviderInfoBO)) != null) {
            tProviderBO.setProduct(productEntity);
            foundProvider = true;
        }
        if (!foundProvider && hasUnionInfo && (tEaiBO = this.queryEaiBOWithUnionProductsInDB(pProviderInfoBO.getTenantId())) != null && (productBO = this.queryProviderUnionProductInEai(pProviderInfoBO, tEaiBO)) != null) {
            tProviderBO.setProduct(productBO.getProduct());
            tProviderBO.setEai(tEaiBO.getEai());
            foundProvider = true;
            this.eaiGateway.saveEaiCache(tEaiBO, pProviderInfoBO.getTenantId());
        }
        if (!foundProvider && (productEntity = this.queryProviderProductInDB(pProviderInfoBO)) != null) {
            tProviderBO.setProduct(productEntity);
            this.productQueryGateWay.saveProductCache(productEntity);
            foundProvider = true;
        }
        if (foundProvider) {
            ServiceEntity serviceEntity = this.findService(tProviderBO, pProviderInfoBO.getName());
            if (serviceEntity == null) {
                throw new ServiceNameNotFoundException();
            }
            tProviderBO.setService(serviceEntity);
        }
        if (!foundProvider) {
            throw new ServiceProviderNotFoundException();
        }
        return tProviderBO;
    }

    private EaiEntity queryProviderEaiInCache(String pTenantId) {
        return this.eaiGateway.getEaiInCacheByTenantId(pTenantId);
    }

    private ProductEntity queryProviderUnionProductInCache(ProviderInfoBO pProviderInfo, String pEaiUid) {
        return this.productQueryGateWay.findUnionProductInCache(pEaiUid, pProviderInfo.getUid(), pProviderInfo.getProd());
    }

    private EaiBO queryEaiBOWithUnionProductsInDB(String pTenantId) {
        return this.eaiGateway.queryEaiWithUnionProductByTenantId(pTenantId);
    }

    private ProductBO queryProviderUnionProductInEai(ProviderInfoBO pProviderInfo, EaiBO pEaiBO) {
        return pEaiBO.getProducts().stream().filter(productBO -> pProviderInfo.getUid().equals(productBO.getProduct().getUid()) && pProviderInfo.getProd().equals(productBO.getProduct().getName())).findFirst().orElse(null);
    }

    private ProductEntity queryProviderProductInCache(ProviderInfoBO pProviderInfo) throws BaseException {
        ProductEntity tProductBO = null;
        String tName = pProviderInfo.getProd();
        String tIp = pProviderInfo.getIp();
        String tApId = pProviderInfo.getId();
        String tUid = pProviderInfo.getUid();
        List<ProductEntity> tProductBOList = this.productQueryGateWay.findProductInCache(tName);
        if (CollectionUtils.isNotEmpty(tProductBOList)) {
            tProductBOList = tProductBOList.stream().filter(productBO -> productBO.getClientOnly() == false).collect(Collectors.toList());
            List<ProductEntity> tSelectedProductBOList = this.filterProductBOList(tProductBOList, tIp, tApId, tUid);
            switch (tSelectedProductBOList.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    tProductBO = tSelectedProductBOList.get(0);
                    break;
                }
                default: {
                    tProductBO = tProductBOList.stream().filter(ProductEntity::getIsDefault).findFirst().orElse(null);
                    if (tProductBO != null) break;
                    throw new DuplicateProductException();
                }
            }
        }
        return tProductBO;
    }

    private ProductEntity queryProviderProductInDB(ProviderInfoBO pProviderInfo) throws BaseException {
        ProductEntity tProductBO = null;
        String tName = pProviderInfo.getProd();
        String tIp = pProviderInfo.getIp();
        String tApId = pProviderInfo.getId();
        String tUid = pProviderInfo.getUid();
        List<ProductEntity> tProductBOList = this.productQueryGateWay.queryNotClientOnlyProductByName(tName);
        if (CollectionUtils.isNotEmpty(tProductBOList)) {
            List<ProductEntity> tSelectedProductBOList = this.filterProductBOList(tProductBOList, tIp, tApId, tUid);
            switch (tSelectedProductBOList.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    tProductBO = tSelectedProductBOList.get(0);
                    break;
                }
                default: {
                    tProductBO = tProductBOList.stream().filter(ProductEntity::getIsDefault).findFirst().orElse(null);
                    if (tProductBO != null) break;
                    throw new DuplicateProductException();
                }
            }
        }
        return tProductBO;
    }

    private List<ProductEntity> filterProductBOList(List<ProductEntity> productBOList, String ip, String apId, String uid) {
        List<Object> tFilterProductBOList = StringUtils.isNotBlank((CharSequence)uid) ? productBOList.stream().filter(productBO -> uid.equals(productBO.getUid())).collect(Collectors.toList()) : (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{ip, apId}) ? productBOList.stream().filter(productBO -> ip.equals(productBO.getIpAddress()) && apId.equals(productBO.getApid())).collect(Collectors.toList()) : (StringUtils.isNotBlank((CharSequence)ip) ? productBOList.stream().filter(productBO -> ip.equals(productBO.getIpAddress())).collect(Collectors.toList()) : (StringUtils.isNotBlank((CharSequence)apId) ? productBOList.stream().filter(productBO -> apId.equals(productBO.getApid())).collect(Collectors.toList()) : productBOList)));
        return tFilterProductBOList;
    }

    private ServiceEntity findService(ProviderBO provider, String srvName) {
        switch (provider.getProductType()) {
            case AGILE: {
                return this.serviceQueryGateway.findService(provider.getProduct().getUid(), srvName);
            }
            case STANDARD: {
                return this.serviceQueryGateway.findUnionService(provider.getEai().getUid(), provider.getProduct().getUid(), srvName);
            }
        }
        return null;
    }
}

