/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.domain.state;

import com.digiwin.cross.domain.bo.StateCodeBO;
import com.digiwin.cross.domain.gateway.IStateCodeGateway;
import com.digiwin.cross.domain.parameter.ApplicationSystemParameter;
import com.digiwin.cross.domain.state.StateEnum;
import com.digiwin.cross.domain.utils.Base64Util;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class StateMessageUtil
implements ApplicationContextAware {
    private static final Log log = LogFactory.getLog(StateMessageUtil.class);
    private static IStateCodeGateway stateCodeGateway;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        stateCodeGateway = (IStateCodeGateway)applicationContext.getBean(IStateCodeGateway.class);
        log.info((Object)"StateMessageUtil: stateCodeGateway initialized.");
    }

    public static String getStateCodeMessage(StateEnum pStateEnum) {
        return StateMessageUtil.getStateCodeMessage(pStateEnum, ApplicationSystemParameter.MESSAGE_LANGUAGE);
    }

    public static String getStateCodeMessage(StateEnum pStateEnum, String pLang) {
        String tLang = StringUtils.defaultString((String)pLang, (String)ApplicationSystemParameter.MESSAGE_LANGUAGE);
        String tReturn = "";
        tLang = tLang.replace("-", "_").toLowerCase();
        StateCodeBO tStateCode = stateCodeGateway.getStateCode(pStateEnum.getCode());
        if (tStateCode != null) {
            tReturn = tLang.equals(Locale.TAIWAN.toString().toLowerCase()) ? tStateCode.getCht() : (tLang.equals(Locale.CHINA.toString().toLowerCase()) ? tStateCode.getChs() : tStateCode.getEng());
        }
        return tReturn;
    }

    public static String getBase64StateCodeMessage(StateEnum pStateEnum, String lang) {
        String message = StateMessageUtil.getStateCodeMessage(pStateEnum, lang);
        try {
            return Base64Util.encodeString(message, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return message;
        }
    }

    public static void initTest(IStateCodeGateway gateway) {
        stateCodeGateway = gateway;
    }
}

