/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.domain.utils;

import com.digiwin.cross.domain.bo.LogBO;
import com.digiwin.cross.domain.bo.LogContent;
import com.digiwin.cross.domain.bo.RequestBO;
import com.digiwin.cross.domain.bo.ResponseBO;
import com.digiwin.cross.domain.bo.ServiceRequestBO;
import com.digiwin.cross.domain.common.ProductType;
import com.digiwin.cross.domain.common.RequestType;
import com.digiwin.cross.domain.state.StateEnum;
import com.digiwin.cross.domain.utils.LogUtil;
import com.digiwin.cross.domain.utils.StringUtil;
import java.util.Calendar;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InvokeLogUtil
extends LogUtil {
    private static final Log log = LogFactory.getLog(InvokeLogUtil.class);

    public static void providerReq(ServiceRequestBO serviceRequest, RequestBO request) {
        try {
            Calendar tTime = Calendar.getInstance();
            StateEnum tStateEnum = null;
            ProductType tProductType = serviceRequest.getProvider().getProductType();
            RequestType tRequestType = serviceRequest.getRequestType();
            block1 : switch (tRequestType) {
                case SYNC: {
                    switch (tProductType) {
                        case AGILE: {
                            tStateEnum = StateEnum.SYNC_CALL_REMOTE;
                            break;
                        }
                        case STANDARD: {
                            tStateEnum = StateEnum.UNION_CALL_CROSSSRV;
                        }
                    }
                    break;
                }
                case FASYNC: {
                    switch (tProductType) {
                        case AGILE: {
                            tStateEnum = StateEnum.FASYNC_CALL_REMOTE;
                            break block1;
                        }
                        case STANDARD: {
                            tStateEnum = StateEnum.UNION_FASYNC_CALL_REMOTE;
                        }
                    }
                }
            }
            LogContent tLogContent = InvokeLogUtil.getLogContent(serviceRequest.getReqId());
            tLogContent.setReqId(serviceRequest.getReqId());
            tLogContent.setRequesterBO(serviceRequest.getHostInfo());
            tLogContent.setProviderBO(serviceRequest.getServiceInfo());
            tLogContent.setServiceDescription(serviceRequest.getProvider().getService().getServiceDescription());
            tLogContent.setReqDataKey(serviceRequest.getDataKey());
            tLogContent.setOperation("invokeSrv");
            if (serviceRequest.getRequester().getEai() != null) {
                tLogContent.setReqEaiIp(serviceRequest.getRequester().getEai().getIpAddress());
            }
            if (serviceRequest.getProvider().getEai() != null) {
                tLogContent.setSrvEaiIp(serviceRequest.getProvider().getEai().getIpAddress());
            }
            LogBO tLogBO = new LogBO(tLogContent);
            tLogBO.setStateEnum(tStateEnum);
            tLogBO.setPlatformTime(tTime);
            switch (serviceRequest.getProvider().getProductType()) {
                case AGILE: {
                    StringBuilder tHttpLine = new StringBuilder();
                    String tRestUrl = serviceRequest.getProvider().getProduct().getRestUrl();
                    String tPathParam = serviceRequest.getPathParam();
                    String tQueryParams = serviceRequest.getQueryParams();
                    tHttpLine.append("POST").append(" ").append(tRestUrl);
                    if (StringUtils.isNotBlank((CharSequence)tPathParam)) {
                        tHttpLine.append(tRestUrl.endsWith("/") ? "" : "/").append(serviceRequest.getPathParam());
                    }
                    if (StringUtils.isNotBlank((CharSequence)tQueryParams)) {
                        tHttpLine.append("?").append(tQueryParams);
                    }
                    tLogBO.setMessage(InvokeLogUtil.convertRestLogMessage(tHttpLine.toString(), request.getHeaders(), request.getBody()));
                    break;
                }
                case STANDARD: {
                    tLogBO.setMessage(InvokeLogUtil.convertRestLogMessage(request.getHeaders(), request.getBody()));
                }
            }
            tLogBO.setMessageSize(StringUtil.calcStringSize(request.getBody()));
            tLogBO.setStepNumber(2);
            InvokeLogUtil.saveLog(tLogBO);
        }
        catch (Exception e) {
            log.error((Object)"log error", (Throwable)e);
        }
    }

    public static void resendProduct(RequestBO request) {
        try {
            Calendar tTime = Calendar.getInstance();
            String tReqId = request.getReqId();
            LogContent tLogContent = InvokeLogUtil.getLogContent(tReqId);
            LogBO tLogBO = new LogBO(tLogContent);
            tLogBO.setStateEnum(StateEnum.SRV_INVO_RETRY);
            tLogBO.setPlatformTime(tTime);
            tLogBO.setMessage(InvokeLogUtil.convertRestLogMessage(request.getHeaders(), request.getBody()));
            tLogBO.setMessageSize(StringUtil.calcStringSize(request.getBody()));
            InvokeLogUtil.saveLog(tLogBO);
        }
        catch (Exception e) {
            log.error((Object)"log error", (Throwable)e);
        }
    }

    public static void resendMq(RequestBO request) {
        try {
            Calendar tTime = Calendar.getInstance();
            String tReqId = request.getReqId();
            LogContent tLogContent = InvokeLogUtil.getLogContent(tReqId);
            LogBO tLogBO = new LogBO(tLogContent);
            tLogBO.setStateEnum(StateEnum.UNION_INVO_RETRY);
            tLogBO.setPlatformTime(tTime);
            tLogBO.setMessage(InvokeLogUtil.convertRestLogMessage(request.getHeaders(), request.getBody()));
            tLogBO.setMessageSize(StringUtil.calcStringSize(request.getBody()));
            InvokeLogUtil.saveLog(tLogBO);
        }
        catch (Exception e) {
            log.error((Object)"log error", (Throwable)e);
        }
    }

    public static void responseRes(String reqId, ResponseBO response, String code, boolean srvResult, RequestType requestType, ProductType productType) {
        try {
            Calendar tTime = Calendar.getInstance();
            StateEnum tStateEnum = null;
            block1 : switch (requestType) {
                case SYNC: {
                    switch (productType) {
                        case AGILE: {
                            if (srvResult) {
                                tStateEnum = StateEnum.SYNC_REMOTE_RETURNED;
                                break;
                            }
                            tStateEnum = StateEnum.SYNC_REMOTE_RETURNED_SRV100;
                            break;
                        }
                        case STANDARD: {
                            if (code.startsWith("0")) {
                                if (srvResult) {
                                    tStateEnum = StateEnum.UNION_REMOTE_RETURNED;
                                    break;
                                }
                                tStateEnum = StateEnum.UNION_REMOTE_RETURNED_SRV100;
                                break;
                            }
                            tStateEnum = StateEnum.UNION_REMOTE_RETURNED_SRV_FAILED;
                        }
                    }
                    break;
                }
                case FASYNC: {
                    switch (productType) {
                        case AGILE: {
                            if (srvResult) {
                                tStateEnum = StateEnum.FASYNC_REMOTE_RETURNED;
                                break block1;
                            }
                            tStateEnum = StateEnum.FASYNC_REMOTE_RETURNED_SRV100;
                            break block1;
                        }
                        case STANDARD: {
                            if (code.startsWith("0")) {
                                if (srvResult) {
                                    tStateEnum = StateEnum.UNION_FASYNC_REMOTE_RETURNED;
                                    break block1;
                                }
                                tStateEnum = StateEnum.UNION_FASYNC_REMOTE_RETURNED_SRV100;
                                break block1;
                            }
                            tStateEnum = StateEnum.UNION_REMOTE_RETURNED_SRV_FASYNC_FAILED;
                        }
                    }
                }
            }
            LogContent logContent = InvokeLogUtil.getLogContent(reqId);
            LogBO tLogBO = new LogBO(logContent);
            tLogBO.setStateEnum(tStateEnum);
            tLogBO.setPlatformTime(tTime);
            tLogBO.setMessage(InvokeLogUtil.convertRestLogMessage(response.getHeaders(), response.getBody()));
            tLogBO.setMessageSize(StringUtil.calcStringSize(response.getBody()));
            tLogBO.setStepNumber(3);
            InvokeLogUtil.saveLog(tLogBO);
            InvokeLogUtil.alarmBigRes(tLogBO);
        }
        catch (Exception e) {
            log.error((Object)"log error", (Throwable)e);
        }
    }
}

