/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.domain.service.impl;

import com.digiwin.cross.domain.bo.entity.ProductEntity;
import com.digiwin.cross.domain.gateway.IProductEditGateway;
import com.digiwin.cross.domain.gateway.IProductQueryGateWay;
import com.digiwin.cross.domain.parameter.ApplicationSystemParameter;
import com.digiwin.cross.domain.service.IProductService;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

@Service
public class ProductService
implements IProductService {
    private static final Log log = LogFactory.getLog(ProductService.class);
    private final IProductQueryGateWay productQueryGateWay;
    private final IProductEditGateway productEditGateway;

    public ProductService(IProductQueryGateWay productQueryGateWay, IProductEditGateway productEditGateway) {
        this.productQueryGateWay = productQueryGateWay;
        this.productEditGateway = productEditGateway;
    }

    @Override
    public boolean validExistsProduct(String uid, String name, String ip, String apId) {
        return this.findExistsProduct(uid, name, ip, apId) != null;
    }

    @Override
    public boolean validExistsOtherProduct(String name, String ip, String apId, Long currentProdId) {
        List<ProductEntity> existsProducts = this.productQueryGateWay.queryProductByApIdAndIpAndName(apId, ip, name, false);
        if (CollectionUtils.isEmpty(existsProducts)) {
            return false;
        }
        for (ProductEntity one : existsProducts) {
            if (one.getId().equals(currentProdId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean validExistsUnionProduct(String uid, String name, String ip, String apId) {
        List<ProductEntity> existsProducts = null;
        if (StringUtils.isNotBlank((CharSequence)uid)) {
            existsProducts = this.productQueryGateWay.queryUnionProductByUid(uid);
        }
        if (StringUtils.isBlank((CharSequence)uid) || CollectionUtils.isEmpty(existsProducts)) {
            existsProducts = this.productQueryGateWay.queryUnionProductByApIdAndIpAndName(apId, ip, name);
        }
        return CollectionUtils.isNotEmpty(existsProducts);
    }

    @Override
    public void saveProductBO(ProductEntity productBO) {
        if (BooleanUtils.isTrue((Boolean)productBO.getClientOnly())) {
            productBO.setIsDefault(false);
        } else {
            List<ProductEntity> sampleNameProducts = this.productQueryGateWay.queryNotClientOnlyProductByName(productBO.getName());
            productBO.setIsDefault(CollectionUtils.isEmpty(sampleNameProducts));
        }
        if (StringUtils.isBlank((CharSequence)productBO.getTimezone())) {
            productBO.setTimezone(ApplicationSystemParameter.APREG_DEFAULT_TIMEZONE);
        }
        if (StringUtils.isBlank((CharSequence)productBO.getUid())) {
            productBO.setUid(this.generateSuggestUID(productBO.getName()));
        }
        this.productEditGateway.saveProduct(productBO);
    }

    @Override
    public ProductEntity updateProductBO(ProductEntity productBO) {
        return this.productEditGateway.updateProduct(productBO);
    }

    @Override
    public ProductEntity findExistsProduct(String uid, String name, String ip, String apId) {
        List<Object> existsProducts = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)uid)) {
            existsProducts = this.productQueryGateWay.queryProductByUid(uid);
        }
        if (StringUtils.isBlank((CharSequence)uid) || CollectionUtils.isEmpty(existsProducts)) {
            existsProducts = this.productQueryGateWay.queryProductByApIdAndIpAndName(apId, ip, name, false);
        }
        return CollectionUtils.isNotEmpty(existsProducts) ? (ProductEntity)existsProducts.get(0) : null;
    }

    @Override
    public ProductEntity findProduct(String uid, String name, String ip, String apId) {
        List<Object> existsProducts = new ArrayList();
        existsProducts = StringUtils.isNotBlank((CharSequence)uid) ? this.productQueryGateWay.queryProductByUid(uid) : this.productQueryGateWay.queryProductByApIdAndIpAndName(apId, ip, name, true);
        return CollectionUtils.isNotEmpty(existsProducts) ? (ProductEntity)existsProducts.get(0) : null;
    }

    @Override
    public ProductEntity deleteProduct(String uid) {
        List<ProductEntity> productEntitys = this.productQueryGateWay.queryProductByUid(uid);
        if (CollectionUtils.isEmpty(productEntitys)) {
            log.warn((Object)"delete product, but product is not exists");
            return null;
        }
        this.productEditGateway.deleteProduct(productEntitys.get(0));
        return productEntitys.get(0);
    }

    private String generateSuggestUID(String pName) {
        String randomThreeDigitNumber;
        boolean tIsExist;
        String tSuggestUID = null;
        do {
            SecureRandom secureRandom = new SecureRandom();
            int randomNumber = secureRandom.nextInt(1000);
            randomThreeDigitNumber = String.format("%03d", randomNumber);
        } while (tIsExist = this.productQueryGateWay.existsUid(tSuggestUID = pName + '_' + randomThreeDigitNumber));
        return tSuggestUID;
    }
}

