/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.domain.service.impl;

import com.digiwin.cross.domain.bo.entity.ProductEntity;
import com.digiwin.cross.domain.bo.entity.ServiceEntity;
import com.digiwin.cross.domain.bo.entity.ServiceProdListEntity;
import com.digiwin.cross.domain.gateway.IServiceEditGateway;
import com.digiwin.cross.domain.gateway.IServiceQueryGateway;
import com.digiwin.cross.domain.parameter.ApplicationSystemParameter;
import com.digiwin.cross.domain.service.ISrvService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

@Service
public class SrvService
implements ISrvService {
    private static final Log log = LogFactory.getLog(SrvService.class);
    private final IServiceQueryGateway serviceQueryGateway;
    private final IServiceEditGateway serviceEditGateway;
    private final List<String> ignoreDuplicateServiceNameList = new ArrayList<String>();

    public SrvService(IServiceQueryGateway serviceQueryGateway, IServiceEditGateway serviceEditGateway) {
        this.serviceQueryGateway = serviceQueryGateway;
        this.serviceEditGateway = serviceEditGateway;
        if (StringUtils.isNotBlank((CharSequence)ApplicationSystemParameter.IGNORE_DUPLICATE_SERVICE_NAME)) {
            this.ignoreDuplicateServiceNameList.addAll(Arrays.asList(ApplicationSystemParameter.IGNORE_DUPLICATE_SERVICE_NAME.split(",")));
        }
    }

    @Override
    public boolean regService(ProductEntity productEntity, ServiceEntity srvBO) {
        try {
            ServiceEntity oldSrv = this.serviceQueryGateway.getSrvByName(srvBO.getProductId(), srvBO.getServiceName(), srvBO.getVersion() != null);
            if (null != oldSrv) {
                srvBO.setId(oldSrv.getId());
                if (oldSrv.getVersion() != null && srvBO.getVersion() != null && StringUtils.equals((CharSequence)oldSrv.getVersion().getVersion(), (CharSequence)srvBO.getVersion().getVersion())) {
                    srvBO.setVersion(null);
                } else if (oldSrv.getVersion() != null && srvBO.getVersion() != null) {
                    srvBO.getVersion().setId(oldSrv.getVersion().getId());
                }
                if (srvBO.getVersion() != null) {
                    srvBO.getVersion().setSrvId(oldSrv.getId());
                }
            }
            this.serviceEditGateway.saveOrUpdateSrv(productEntity, srvBO);
            return true;
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
    }

    @Override
    public boolean unRegisterSrv(ProductEntity product, String serviceName) {
        try {
            ServiceEntity oldSrv = this.serviceQueryGateway.getSrvByName(product.getId(), serviceName, false);
            if (null == oldSrv) {
                log.error((Object)String.format("unreg srv [%s], srv not exists", serviceName));
                return false;
            }
            this.serviceEditGateway.deleteSrv(product, oldSrv);
            return true;
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
    }

    @Override
    public void checkDuplicate(List<ServiceEntity> serviceEntities) {
        if (CollectionUtils.isNotEmpty(serviceEntities)) {
            List ignoreDuplicateServiceNamePatterns = this.ignoreDuplicateServiceNameList.stream().map(Pattern::compile).collect(Collectors.toList());
            List<String> tSrvNames = serviceEntities.stream().map(ServiceEntity::getServiceName).filter(srvName -> ignoreDuplicateServiceNamePatterns.stream().noneMatch(pattern -> pattern.matcher((CharSequence)srvName).matches())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(tSrvNames)) {
                List<ServiceProdListEntity> tServiceProdListEntityList = this.serviceQueryGateway.queryServiceWithProductNames(tSrvNames);
                String tRegProd = serviceEntities.get(0).getProdName();
                List<ServiceProdListEntity> tDuplicateEntityList = tServiceProdListEntityList.stream().filter(entity -> {
                    if (entity.getProductNames().stream().anyMatch(prodName -> !prodName.equals(tRegProd))) {
                        entity.getProductNames().remove(tRegProd);
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(tDuplicateEntityList)) {
                    this.serviceQueryGateway.alarmDuplicateService(tDuplicateEntityList, tRegProd);
                }
            }
        }
    }
}

