package com.digiwin.cross.domain.bo;

import com.digiwin.cross.domain.common.HeaderNamesConstant;
import com.digiwin.cross.domain.state.StateEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.Map;

/**
 * @description:
 * @author: clay
 * @date: 2023/6/26
 */
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class ResponseBO {
    private Map<String, String> headers;
    private String body;

    public boolean isBusinessSuccess() {
        return "000".equals(headers.get(HeaderNamesConstant.DIGI_SRVCODE));
    }

    public boolean isEaiSuccess() {
        return StateEnum.UNION_FASYNC_CALLBACK_RESULT.getCode().equals(headers.get(HeaderNamesConstant.DIGI_CODE));
    }
}
