package com.digiwin.cross.domain.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author songwq
 * @ClassName EaiTypeEnum
 * @description: 中台类型
 * @date 2025年07月16日
 * @version: 1.0
 */
public enum EaiTypeEnum {
    // 数环通iPaaS
    EAI_TYPE_SHUHUANTONG("0", "shuhuantong"),

    // 幂链iPaaS
    EAI_TYPE_MILIAN("1", "milian"),

    // CROSS
    EAI_TYPE_CROSS("2", "cross");

    /**
     * code
     */
    private final String code;

    /**
     * type 描述
     */
    private final String type;

    /**
     * 映射MAP
     */
    private static final Map<String, EaiTypeEnum> EAI_TYPE_MAP = new HashMap<>();

    /**
     * 将所有类型加入EAI_TYPE_MAP
     */
    static {
        for (EaiTypeEnum tEnum : values()) {
            EAI_TYPE_MAP.put(tEnum.getType(), tEnum);
        }
    }

    EaiTypeEnum(String code, String type) {
        this.code = code;
        this.type = type;
    }

    public String getCode() {
        return code;
    }

    public String getType() {
        return type;
    }

}
