package com.digiwin.cross.domain.exception;

import com.digiwin.cross.domain.state.StateEnum;

import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * @description:
 * @author: clay
 * @date: 2023/6/27
 */
public class PlatformUnknowException extends BaseException {
    public PlatformUnknowException () {
        super(StateEnum.PLAT_UNKNOW);
    }

    public PlatformUnknowException (Throwable e) {
        super(StateEnum.PLAT_UNKNOW, getStackTraceAsString(e));
    }

    public PlatformUnknowException (String errorMessage) {
        super(StateEnum.PLAT_UNKNOW, errorMessage);
    }

    public PlatformUnknowException (String errorMessage, Throwable e) {
        super(StateEnum.PLAT_UNKNOW, errorMessage + "\n" + getStackTraceAsString(e));
    }

    // 将堆栈信息转换为字符串
    private static String getStackTraceAsString (Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }
}
