package com.digiwin.cross.domain.gateway;

import com.digiwin.cross.domain.bo.entity.ProductEntity;

import java.util.List;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/5/26 15:36
 */
public interface IProductQueryGateWay {

    List<ProductEntity> queryProductByUid(String uid);

    ProductEntity queryProductById(Long id);

    ProductEntity queryUnionProductById(Long id);

    List<ProductEntity> queryProductByApIdAndIpAndName(String apId, String ip, String name, boolean ignoreNullId);

    List<ProductEntity> queryUnionProductByUid(String uid);

    List<ProductEntity> queryUnionProductByApIdAndIpAndName(String apId, String ip, String name);

    List<ProductEntity> queryNotClientOnlyProductByName(String name);

    List<ProductEntity> queryAllNotClientOnlyProduct();

    ProductEntity findProductInCache(String name, String ip, String apId, String uid);

    ProductEntity findProductInDB(String name, String ip, String apId, String uid);

    void saveProductCache(ProductEntity productEntity);

    ProductEntity findUnionProductInCache(String eaiUid, String prodUid, String prodName);

    List<ProductEntity> findProductInCache(String name);

    List<ProductEntity> findProductInDB(String name);

    boolean existsUid(String uid);

    /**
     * 查询所有产品，敏态 + 稳态
     * @return
     */
    List<ProductEntity> queryAllProduct();

    /**
     * 查询所有产品，敏态 + 稳态
     * @return
     */
    List<ProductEntity> queryUnionProduct(Long eaiUid);

    List<ProductEntity> queryProductByCondition(ProductEntity productEntity);

}
