package com.digiwin.cross.domain.parameter;

import com.digiwin.cross.domain.utils.SpringContextUtil;
import lombok.extern.apachecommons.CommonsLog;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.Base64Utils;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;

/**
 * @description:
 * @author: clay
 * @date: 2023/6/1
 */
public class PropertiesParameter {
    /**
     * @param pClass 傳入繼承類別的class
     * @throws Exception
     */
    public static void loadParameter (Class<? extends PropertiesParameter> pClass) {
        Log log = LogFactory.getLog(pClass);
        loadProperties(null, pClass, log);


//        PropertiesFile tFileAnnotation = pClass.getAnnotation(PropertiesFile.class);
//        String tFileName = tFileAnnotation.value();
//        Path filePath;
//        try {
//            filePath = Paths.get(new FileSystemResource("conf/" + tFileName).getURI());
//        } catch (IOException e) {
//            log.error("load parameter error", e);
//            throw new RuntimeException(e);
//        }
//        if (Files.notExists(filePath)) {
//            log.warn("load parameter file [" + filePath.toString() + "] not exists");
//            return;
//        }
//        try (InputStream loadPorIS = Files.newInputStream(filePath)) {
//            Properties tProps = new Properties();
//            tProps.load(loadPorIS);
//            loadProperties(tProps, pClass, log);
//        } catch (Exception e) {
//            log.error("load parameter error", e);
//            throw new RuntimeException(e);
//        }
    }


    private static void loadProperties (Properties properties, Class<? extends PropertiesParameter> pClass, Log log) {
        System.out.println(pClass.getDeclaredFields());
        for (Field tField : pClass.getDeclaredFields()) {
            try {
                PropertiesKey tKeyAnnotation = tField.getAnnotation(PropertiesKey.class);
                if(null==tKeyAnnotation){
                    System.out.println(pClass+" field has no PropertiesKey annotation "+tField.getName());
                    continue;
                }
                String tKey = tKeyAnnotation.value();
                boolean tIsBase64 = tKeyAnnotation.isBase64();

            //    String tValue = properties.getProperty(tKey);
                String tValue = SpringContextUtil.getStringProp(tKey);
                log.info(tField.getName() + "=" + tValue);
                if (StringUtils.isNotBlank(tValue)) {
                    tValue = tValue.trim();
                    if (tIsBase64) {
                        tValue = new String(Base64Utils.decodeFromString(tValue));
                    }
                    Class<? extends Object> tClass = tField.getType();
                    //字串類型直接設置
                    if (tClass.equals(String.class)) {
                        tField.set(null, tValue);
                    } else {
                        //其他型態使用valueOf方法設置
                        try {
                            Method tMethod = tClass.getMethod("valueOf", String.class);
                            tField.set(null, tMethod.invoke(null, tValue));
                        } catch (NoSuchMethodException | InvocationTargetException e) {
                            log.warn("Not support properties type:" + tClass.getName());
                            log.error(e.getMessage(), e);
                        }
                    }
                }
            } catch (Exception e) {
                log.error("Load property field:" + tField.getName() + "fail");
                log.error(e.getMessage(), e);
            }
        }
    }

}
