package com.digiwin.cross.domain.service;

import com.digiwin.cross.domain.bo.entity.ProductEntity;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/5/26 15:37
 */
public interface IProductService {
    /**
     * 是否存在敏态产品
     * @param uid
     * @param name
     * @param ip
     * @param apId
     * @return
     */
    boolean validExistsProduct(String uid, String name, String ip, String apId);
    /**
     * 是否存在其他敏态产品
     * @param name
     * @param ip
     * @param apId
     * @return
     */
    boolean validExistsOtherProduct(String name, String ip, String apId, Long currentProdId);

    /**
     * 是否存在稳态产品
     * @param uid
     * @param name
     * @param ip
     * @param apId
     * @return
     */
    boolean validExistsUnionProduct(String uid, String name, String ip, String apId);

    void saveProductBO(ProductEntity productBO);

    ProductEntity updateProductBO(ProductEntity productBO);

    /**
     * 查找产品
     * @param uid
     * @param name
     * @param ip
     * @param apId
     * @return
     */
    ProductEntity findExistsProduct(String uid, String name, String ip, String apId);

    ProductEntity findProduct(String uid, String name, String ip, String apId);

    ProductEntity deleteProduct(String uid);
}
