package com.digiwin.cross.domain.service.validator;


import com.digiwin.cross.domain.exception.ValidatorException;

import java.util.Map;

public abstract class RestMessageValidator {

    protected Map<String, String> headers;
    protected String body;

    public void validator(Map<String, String> pHeaders, String pBody) throws ValidatorException {
        this.headers = pHeaders;
        this.body = pBody;
        validatorHeader(headers);
        validatorBody(body);
    }

    protected abstract void validatorHeader(Map<String, String> pHeaders) throws ValidatorException;

    protected abstract void validatorBody(String pBody) throws ValidatorException;
}
