/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.domain.service.validator;

import com.digiwin.cross.domain.exception.JsonValidatorException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsonValidator {
    protected Logger log;
    private JsonSchema schema;
    private ObjectMapper objectMapper = new ObjectMapper();

    public JsonValidator(Class<? extends JsonValidator> pClass, String pSchemaFileName) throws Exception {
        this.log = LoggerFactory.getLogger(pClass);
        this.schema = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V4).getSchema(this.objectMapper.readTree(ClassLoader.getSystemResourceAsStream("jsonSchema/" + pSchemaFileName)));
        this.objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
    }

    public void validate(String pJsonStr, String pTargetName) throws JsonValidatorException {
        if (StringUtils.isBlank((CharSequence)pJsonStr)) {
            String tMessage = String.format("'%s' content is empty", pTargetName);
            throw new JsonValidatorException(tMessage);
        }
        try {
            Set tValidationMessages = this.schema.validate(this.objectMapper.readTree(pJsonStr));
            if (tValidationMessages.size() > 0) {
                JsonObject tErrorMessage = new JsonObject();
                JsonArray tDetialArray = new JsonArray();
                tErrorMessage.add(pTargetName, (JsonElement)tDetialArray);
                for (ValidationMessage tValidationMessage : tValidationMessages) {
                    tDetialArray.add(tValidationMessage.getMessage());
                }
                throw new JsonValidatorException(tErrorMessage.toString());
            }
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            String tMessage = String.format("'%s' cant't parse: %s", pTargetName, e.getMessage());
            throw new JsonValidatorException(tMessage);
        }
    }
}

