/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.domain.state;

import java.util.HashMap;
import java.util.Map;

public enum StateEnum {
    MSG_RECEIVED("000"),
    SYNC_SRV_START_WAIT("013"),
    SYNC_CALL_REMOTE("014"),
    SYNC_REMOTE_RETURNED("015"),
    SYNC_REMOTE_RETURNED_SRV100("016"),
    SYNC_MSG_RETURNED("019"),
    UNION_CALL_CROSSSRV("0C4"),
    UNION_REMOTE_RETURNED("0C5"),
    UNION_REMOTE_RETURNED_SRV100("0C6"),
    UNION_REMOTE_RETURNED_SRV_FAILED("0C7"),
    FASYNC_SRV_START_WAIT("0E3"),
    FASYNC_CALL_REMOTE("0E4"),
    FASYNC_REMOTE_RETURNED("0E5"),
    FASYNC_REMOTE_RETURNED_SRV100("0E6"),
    FASYNC_MSG_RETURNED("0E9"),
    FASYNC_REMOTE_CALLBACK("0E0"),
    FASYNC_REMOTE_CALLBACKED("0EA"),
    FASYNC_REMOTE_CALLBACKED_SRV100("0EB"),
    FASYNC_CALLBACK("0ED"),
    FASYNC_CALLBACKED("0EE"),
    FASYNC_CALLBACKED_SRV100("0EF"),
    FASYNC_CALLBACK_RESULT("0EG"),
    UNION_FASYNC_SRV_START_WAIT("0F3"),
    UNION_FASYNC_CALL_REMOTE("0F4"),
    UNION_FASYNC_REMOTE_RETURNED("0F5"),
    UNION_FASYNC_REMOTE_RETURNED_SRV100("0F6"),
    UNION_FASYNC_MSG_RETURNED("0F9"),
    UNION_FASYNC_REMOTE_CALLBACKED("0FA"),
    UNION_FASYNC_REMOTE_CALLBACKED_SRV100("0FB"),
    UNION_FASYNC_CALLBACK("0FD"),
    UNION_FASYNC_CALLBACKED("0FE"),
    UNION_FASYNC_CALLBACKED_SRV100("0FF"),
    UNION_FASYNC_CALLBACK_RESULT("0FG"),
    MDC_OMMAP_NOT_FOUND("221"),
    MDC_VALIDATION_ERROR("222"),
    MDC_CONNECTION_FAIL("223"),
    UNION_REMOTE_RETURNED_SRV_FASYNC_FAILED("0F7"),
    REGPROD_MSG_CHECKED("050"),
    REGPROD_REGED("054"),
    REGPROD_UPDED("055"),
    REGPROD_DELED("056"),
    REGEAI_REGED("057"),
    REGEAI_UPDED("058"),
    REGEAI_DELED("059"),
    REGSRV_MSG_CHECKED("060"),
    REGSRV_REGED("064"),
    REGSRV_UPDED("065"),
    REGSRV_DELED("066"),
    SYNCPROD_FORMAT_ERROR("819"),
    SYNCPROD_FAILED("820"),
    SYNC_MDC_ERR("831"),
    MQ_CONN_SUCCESS("061"),
    INFO_PRODLIST("091"),
    INFO_PROD("092"),
    INFO_SRVLIST("093"),
    INFO_PARAMLIST("094"),
    GET_STANDARD_SERVICE_LIST_SUCCESS("096"),
    GET_STANDARD_DATANAME_LIST_SUCCESS("097"),
    VAL_MSG_IN_FORMAT("101"),
    VAL_MSG_IN_SECURITY("102"),
    VAL_MSG_IN_DECODING("103"),
    VAL_MSG_NOT_XML_JSON("105"),
    VAL_MSG_OVERLIMIT("104"),
    VAL_MSG_IN_DECRYPT("106"),
    VAL_SRV_NAME_NOT_FOUND("201"),
    VAL_SRV_VER_NOT_FOUND("202"),
    VAL_SRV_PROVIDER_NOT_FOUND("203"),
    VAL_SRV_MORE_THAN_ONE_PROD("204"),
    VAL_REQ_PROD_NOT_FOUND("205"),
    VAL_SRV_NAME_NULL("207"),
    VAL_SRV_DEFAULT_AP_NOT_FOUND("206"),
    REST_SRV_NOT_SUPPORT("208"),
    WEBSRV_NOT_SUPPORT("209"),
    CROSS_SRV_NOT_SUPPORT_REST("211"),
    VAL_SRV_CROSS_NOT_FOUND("283"),
    VAL_REQ_CROSS_NOT_FOUND("285"),
    LOCAL_EAI_INVOKE_TENANTID_NOT_FOUND("286"),
    SRV_INVO_RETRY("301"),
    SRV_INVO_CONN("311"),
    SRV_INVO_WS_METHOD("312"),
    VAL_MSG_RETURN_SRV("321"),
    VAL_MSG_RETURN_NOT_XML_JSON("325"),
    SRV_INVO_CATCH_EXCEPTION("322"),
    SRV_INVO_RETURNED_NULL("323"),
    VAL_MSG_RETURN_DECODING("324"),
    VAL_MSG_RETURN_DECRYPT("327"),
    FASYNC_REMOTE_CALLBACK_REQID_NOTFOUND("328"),
    FASYNC_REMOTE_CALLBACK_MISS_REQID("329"),
    FASYNC_REMOTE_CALLBACK_REQID_PROCESSED("32B"),
    SRV_INVO_TIMEOUT("331"),
    UNION_INVO_TIMEOUT("3C1"),
    UNION_INVO_CONN("3C2"),
    UNION_INVO_RETRY("302"),
    GATEWAY_CONN_FAIL("3C3"),
    GATEWAY_FUSING_FAIL("3C4"),
    SRV_INVO_BUSY("332"),
    CROSS_SRV_THROW_EXCEPTION("326"),
    ASYNC_MANUAL_CALLBACK("306"),
    REQ_INVO_CONN("361"),
    REQ_INVO_WS_METHOD("362"),
    REQ_VAL_MSG_RETURN_SRV("371"),
    REQ_VAL_MSG_NOT_XML_JSON("376"),
    REQ_INVO_CATCH_EXCEPTION("372"),
    REQ_INVO_RETURNED_NULL("373"),
    ASYNC_CALLBACKED_SRV100("374"),
    REQ_VAL_MSG_DECODING("375"),
    REQ_VAL_MSG_DECRYPT("377"),
    REQ_INVO_TIMEOUT("381"),
    PLAT_DB("908"),
    PLAT_MQ("909"),
    PLAT_MEMORY("910"),
    PLAT_ESB_SEND_ASYNC("901"),
    PLAT_ESB_SEND_MDM("906"),
    PLAT_STUBCODE_NOTFOUND("902"),
    PLAT_STUBCODE_INVO_OBJ_UNKNOW("903"),
    PLAT_STUBCODE_EST_INVO_OBJ("904"),
    PLAT_STUBCODE_INVO_OBJ_NO_METHOD("905"),
    PLAT_STUBCODE_EST_UNKNOW("906"),
    PLAT_CROSS_SRV_OBJ_NOTFOUND("911"),
    PLAT_CROSS_CALL_EAI_API_ERR("912"),
    FTP_JOB_NOTFOUND("921"),
    FTP_TRANSPORT_FAIL("922"),
    PLAT_NOT_SUPPORT("998"),
    PLAT_UNKNOW("999"),
    REG_PROD_EXIST("811"),
    REG_PROD_NOWSDL("801"),
    REG_PROD_PARSEWSDL("802"),
    REG_PROD_LACK_WSDL_METHOD("818"),
    REG_PROD_GEN_WS_CODE("803"),
    REG_PROD_PARSEREST("804"),
    REG_PROD_AUTH_FAIL("881"),
    REG_PROD_IP_INCONSISTENT("807"),
    REG_PROD_CLIENTONLY_CANNOT_MODIFIED("808"),
    REG_AMBIGUOUS_PROD("813"),
    REG_PROD_NOTFOUND("806"),
    REG_SRV_ONE_MORE_FAILED("810"),
    UPDATE_PROD_UID_MODIFY_FAIL("812"),
    SRV_RETURNED_PROD_REG_THROW_EXCEPTION("814"),
    SRV_RETURNED_PROD_REG_ERROR_FORMAT("815"),
    SRV_RETURNED_SRV_REG_THROW_EXCEPTION("816"),
    SRV_RETURNED_SRV_REG_ERROR_FORMAT("817"),
    MQ_CONN_FAILED("821"),
    DUPLICATE_PRODUCT_EXCEPTION("822"),
    REG_PROD_LACK_SYNCPROD("823"),
    UNION_LOCAL_LACK_EXT_IP("841"),
    UNION_REG_EAI_NOTFOUND("842"),
    UNION_PROD_EXIST("843"),
    UNION_LOCAL_LACK_UID("844"),
    UNION_TENANT_EXISTS("845"),
    UNION_REMOTE_LACK_EXT_IP("8C1"),
    UNION_LOSS_EAI("8C2"),
    UNION_LOCAL_CONN("8C3"),
    ETL_RUN_SUCCESS("049"),
    ETL_RUN_FALSE("411"),
    ETL_RUN_TIMEOUT("421"),
    ETL_NO_JOB("401"),
    ETL_NO_JOBVERSION("402"),
    MSG_DECENTRALIZATION_RECEIVED("D00");

    public static final Map<String, StateEnum> STATEENUM_CODE_MAP;
    private final String code;

    private StateEnum(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public int getState() {
        switch (this) {
            case MSG_DECENTRALIZATION_RECEIVED: 
            case ASYNC_MANUAL_CALLBACK: {
                return 0;
            }
            case SYNC_REMOTE_RETURNED_SRV100: 
            case UNION_REMOTE_RETURNED_SRV100: 
            case ASYNC_CALLBACKED_SRV100: 
            case FASYNC_REMOTE_CALLBACKED_SRV100: 
            case UNION_FASYNC_REMOTE_CALLBACKED_SRV100: 
            case FASYNC_CALLBACKED_SRV100: 
            case FASYNC_REMOTE_RETURNED_SRV100: 
            case UNION_FASYNC_CALLBACKED_SRV100: 
            case UNION_FASYNC_REMOTE_RETURNED_SRV100: 
            case UNION_REMOTE_RETURNED_SRV_FAILED: 
            case UNION_REMOTE_RETURNED_SRV_FASYNC_FAILED: {
                return 2;
            }
        }
        if (this.code.startsWith("0")) {
            return 0;
        }
        return 1;
    }

    static {
        STATEENUM_CODE_MAP = new HashMap<String, StateEnum>();
        for (StateEnum tEnum : StateEnum.values()) {
            STATEENUM_CODE_MAP.put(tEnum.getCode(), tEnum);
        }
    }
}

