/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.domain.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;

public class GZipUtil {
    public static String compress(byte[] data) throws IOException {
        byte[] newData;
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("data is null or empty");
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             GZIPOutputStream gzip = new GZIPOutputStream(baos);){
            gzip.write(data);
            gzip.finish();
            gzip.flush();
            newData = baos.toByteArray();
        }
        return Base64.encodeBase64String((byte[])newData);
    }

    public static String decompress(String pCompressData) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (ByteArrayInputStream tByteArrayInputStream = new ByteArrayInputStream(Base64.decodeBase64((String)pCompressData));
             GZIPInputStream tGzipInputStream = new GZIPInputStream(tByteArrayInputStream);){
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)tGzipInputStream, "UTF-8"));
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

