/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.domain.utils;

import com.digiwin.cross.domain.exception.InvokeRestFormatValidationException;
import com.digiwin.cross.domain.exception.MessageNotXMLorJSONValidationException;
import com.digiwin.cross.domain.exception.ValidatorException;
import com.digiwin.cross.domain.utils.JsonUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonSchemaUtil {
    private static final Log log = LogFactory.getLog(JsonSchemaUtil.class);
    private static Map<String, JsonSchema> schemaMap = new ConcurrentHashMap<String, JsonSchema>();

    private static JsonSchema getSchema(String pSchemaFileName) {
        Function<String, JsonSchema> createSchema = key -> {
            InputStream jsonFileStream = null;
            try {
                jsonFileStream = ClassLoader.getSystemResourceAsStream(key);
                JsonSchema jsonSchema = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V4).getSchema(JsonUtil.readJsonNode(jsonFileStream));
                return jsonSchema;
            }
            finally {
                try {
                    if (jsonFileStream != null) {
                        jsonFileStream.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)("\u5173\u95ed\u6587\u4ef6" + pSchemaFileName + "IO\u5f02\u5e38"), (Throwable)e);
                }
            }
        };
        return schemaMap.computeIfAbsent(pSchemaFileName, createSchema);
    }

    public static void validate(String schemaFileUrl, String pJsonStr, String pTargetName) throws ValidatorException {
        if (StringUtils.isBlank((CharSequence)pJsonStr)) {
            String tMessage = String.format("'%s' content is empty", pTargetName);
            throw new InvokeRestFormatValidationException(tMessage);
        }
        try {
            JsonSchema schema = JsonSchemaUtil.getSchema(schemaFileUrl);
            JsonNode node = JsonUtil.readJsonNode(pJsonStr);
            Set tValidationMessages = schema.validate(node);
            if (tValidationMessages.size() > 0) {
                JsonObject tErrorMessage = new JsonObject();
                JsonArray tDetialArray = new JsonArray();
                tErrorMessage.add(pTargetName, (JsonElement)tDetialArray);
                for (ValidationMessage tValidationMessage : tValidationMessages) {
                    tDetialArray.add(tValidationMessage.getMessage());
                }
                throw new InvokeRestFormatValidationException(tErrorMessage.toString());
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            String tMessage = String.format("'%s' cant't parse: %s", pTargetName, e.getMessage());
            if (e instanceof InvokeRestFormatValidationException) {
                throw e;
            }
            throw new MessageNotXMLorJSONValidationException(tMessage);
        }
    }
}

