/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.cross.domain.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.digiwin.cross.domain.bo.LogBO;
import com.digiwin.cross.domain.bo.LogContent;
import com.digiwin.cross.domain.gateway.ILogGateway;
import com.digiwin.cross.domain.parameter.ApplicationSystemParameter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;

public class LogUtil {
    private static final Log log = LogFactory.getLog(LogUtil.class);
    protected static Map<String, LogContent> logContentMap = Collections.synchronizedMap(new HashMap());
    protected static Map<String, LogContent> callbackLogContentMap = Collections.synchronizedMap(new HashMap());
    protected static ExecutorService executor;
    private static ILogGateway logGateway;

    public static void setDependencies(ExecutorService executorService, ILogGateway logGateway) {
        executor = executorService;
        LogUtil.logGateway = logGateway;
    }

    protected static void saveLog(LogBO logBO) {
        LogUtil.saveLog(logBO, false);
    }

    protected static void saveLog(LogBO logBO, boolean isCallback) {
        LogContent tLogContent = null;
        tLogContent = isCallback ? callbackLogContentMap.get(logBO.getReqId()) : logContentMap.get(logBO.getReqId());
        tLogContent.setLogDisplayPriority(tLogContent.getLogDisplayPriority() + 1);
        logBO.setLogDisplayPriority(tLogContent.getLogDisplayPriority());
        log.info((Object)"init ptxid");
        logBO.setPinpointId(ThreadContext.get((String)"PtxId"));
        executor.execute(() -> logGateway.writeLog(logBO));
    }

    public static LogContent initLog(String reqId, int ... priority) {
        return LogUtil.initLog(reqId, false, priority);
    }

    public static LogContent initLog(String reqId, boolean isCallback, int ... priority) {
        LogContent tLogContent = new LogContent();
        if (priority.length == 0) {
            tLogContent.setLogDisplayPriority(0);
        } else {
            tLogContent.setLogDisplayPriority(priority[0]);
        }
        if (isCallback) {
            callbackLogContentMap.put(reqId, tLogContent);
        } else {
            logContentMap.put(reqId, tLogContent);
        }
        tLogContent.setReqId(reqId);
        return tLogContent;
    }

    protected static LogContent getLogContent(String reqId) {
        return LogUtil.getLogContent(reqId, false);
    }

    protected static LogContent getLogContent(String reqId, boolean isCallback) {
        if (isCallback) {
            return callbackLogContentMap.get(reqId);
        }
        return logContentMap.get(reqId);
    }

    protected static void finalizeLog(String reqId) {
        LogUtil.finalizeLog(reqId, false);
    }

    protected static void finalizeLog(String reqId, boolean isCallback) {
        if (isCallback) {
            callbackLogContentMap.remove(reqId);
        } else {
            logContentMap.remove(reqId);
        }
    }

    public static byte[] convertRestLogMessage(Map<String, String> headerMap, String body) {
        return LogUtil.convertRestLogMessage(null, headerMap, body);
    }

    public static byte[] convertRestLogMessage(String httpLine, Map<String, String> headerMap, String body) {
        return LogUtil.convertRestLogMessage(httpLine, headerMap, body, null);
    }

    public static byte[] convertRestLogMessage(String httpLine, Map<String, String> headerMap, String body, String ptxId) {
        StringBuffer tStrBuffer = new StringBuffer();
        String pinpointId = ThreadContext.get((String)"PtxId");
        if (ptxId != null) {
            pinpointId = ptxId;
        }
        if (pinpointId != null) {
            tStrBuffer.append("pinpointId").append(": ").append(pinpointId).append(System.lineSeparator());
        }
        if (httpLine != null) {
            tStrBuffer.append(httpLine).append(System.lineSeparator());
        }
        tStrBuffer.append(System.lineSeparator());
        headerMap.forEach((headerName, headerValue) -> tStrBuffer.append((String)headerName).append(": ").append((String)headerValue).append(System.lineSeparator()));
        if (StringUtils.isNotBlank((CharSequence)body)) {
            tStrBuffer.append(System.lineSeparator());
            tStrBuffer.append(body);
        }
        return LogUtil.compress(tStrBuffer.toString());
    }

    protected static String getAppId(Map<String, String> headers) {
        if (headers.containsKey("digi-middleware-auth-app")) {
            try {
                String tAppToken = headers.get("digi-middleware-auth-app");
                if (StringUtils.isBlank((CharSequence)tAppToken)) {
                    return null;
                }
                DecodedJWT jwt = JWT.decode((String)tAppToken);
                return jwt.getClaim("id").asString();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    protected static void alarmBigRes(LogBO logBO) {
        if (logBO.getMessageSize() >= (double)(ApplicationSystemParameter.BIG_RES_SIZE * 1024)) {
            logGateway.alarmBigRes(logBO);
        }
    }

    private static byte[] compress(String message) {
        if (StringUtils.isNotBlank((CharSequence)message)) {
            ByteArrayOutputStream tOutput = new ByteArrayOutputStream();
            try (GZIPOutputStream tZip = new GZIPOutputStream(tOutput);){
                tZip.write(message.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            return tOutput.toByteArray();
        }
        return null;
    }
}

