package com.digiwin.cross.infrastructure.cache;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.concurrent.TimeUnit;

@AllArgsConstructor
@Getter
public enum CacheKeyEnum {

	ESP_PRODUCT_INFO_NEW_V2("esp:product:agile2", TimeUnit.DAYS.toSeconds(5), TimeUnit.HOURS.toSeconds(12)),
	ESP_UNION_PRODUCT_INFO_NEW("esp:product:standard", TimeUnit.DAYS.toSeconds(5), TimeUnit.HOURS.toSeconds(12)),
	ESP_TENANT_EAI_MAPPING_NEW("esp:tenant_eai_mapping", TimeUnit.DAYS.toSeconds(5), TimeUnit.HOURS.toSeconds(12)),
	ESP_UNION_EAI_INFO_NEW("esp:eai", TimeUnit.DAYS.toSeconds(5), TimeUnit.HOURS.toSeconds(12)),
	ESP_SERVICE_INFO_NEW("esp:service:agile", TimeUnit.DAYS.toSeconds(5), TimeUnit.HOURS.toSeconds(12)),
	ESP_UNION_SERVICE_INFO_NEW("esp:service:standard", TimeUnit.DAYS.toSeconds(5), TimeUnit.HOURS.toSeconds(12)),
	ESP_FULLASYNC_JSON_NEW("esp:fullasync_req", TimeUnit.DAYS.toSeconds(1), null),
	ESP_MDC_ERR_FLAG("esp:mdc_err_flag", null, null),
	ESP_SWITCH("esp:switch", null, null),
	ESP_EAI_FUSING("esp:eai_fusing", 90L, null),
	ESP_PRODUCT_CALLBACK_TIMEOUT("esp:product_callback_timeout", null, null),
	ESP_SERVICE_CALLBACK_TIMEOUT("esp:service_callback_timeout", null, null);

    private String cacheName;

    //远程缓存过期时间，单位秒
    private Long timeToLiveSeconds;

    //远程缓存过期时间，单位秒
    private Long maxRandomLiveSeconds;

}
