package com.digiwin.cross.infrastructure.convertor;

import com.digiwin.athena.esp.sdk.util.StringUtil;
import com.digiwin.cross.domain.bo.entity.EaiEntity;
import com.digiwin.cross.domain.enums.EaiTypeEnum;
import com.digiwin.cross.infrastructure.database.entity.UnionEAIPO;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/6/13 14:22
 */
public class EaiConvertor {

    public static EaiEntity convertToBO(UnionEAIPO po) {
        if (null == po) {
            return null;
        }
        EaiEntity bo = new EaiEntity();
        bo.setId(po.getId());
        bo.setUid(po.getUid());
        bo.setIpAddress(po.getIpAddress());
        bo.setGatewayId(po.getGatewayId());
        bo.setGatewayName(po.getGatewayName());
        bo.setRemark(po.getRemark());
        bo.setLongConnId(po.getLongConnId());
        return bo;
    }

    public static UnionEAIPO convertToPO(EaiEntity bo) {
        if (null == bo) {
            return null;
        }
        UnionEAIPO po = new UnionEAIPO();
        po.setId(bo.getId());
        po.setIpAddress(bo.getIpAddress());
        po.setUid(bo.getUid());

        // 新增中台时，为了区分iPaas与cross的区别
        // 针对前缀进行处理
        if (StringUtil.isEmpty(bo.getRemark())) {
            // 为空直接设置CROSS
            po.setRemark(EaiTypeEnum.EAI_TYPE_CROSS.getType());
        } else if (bo.getRemark().startsWith(EaiTypeEnum.EAI_TYPE_SHUHUANTONG.getType())
                || bo.getRemark().startsWith(EaiTypeEnum.EAI_TYPE_MILIAN.getType())
                || bo.getRemark().startsWith(EaiTypeEnum.EAI_TYPE_CROSS.getType())) {
            po.setRemark(bo.getRemark());
        } else {
            // 如果没有前缀，直接拼接默认前缀
            po.setRemark(EaiTypeEnum.EAI_TYPE_CROSS.getType() + bo.getRemark());
        }
        po.setLongConnId(bo.getLongConnId());
        po.setGatewayId(bo.getGatewayId());
        po.setGatewayName(bo.getGatewayName());
        po.setIsvalid(true);
        return po;
    }
}
