package com.digiwin.cross.infrastructure.convertor;

import com.digiwin.cross.domain.bo.ProductBO;
import com.digiwin.cross.domain.bo.entity.ProductEntity;
import com.digiwin.cross.domain.common.ProductType;
import com.digiwin.cross.infrastructure.database.entity.ProductPO;
import com.digiwin.cross.infrastructure.database.entity.UnionProductPO;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/6/6 13:54
 */
public class ProductConvertor {

    public static ProductEntity convertToBOEntity(ProductPO po) {
        if (null == po) {
            return null;
        }
        ProductEntity bo = new ProductEntity(ProductType.AGILE);
        bo.setUid(po.getUid());
        bo.setName(po.getName());
        bo.setApid(po.getApid());
        bo.setTimezone(po.getTimezone());
        bo.setVersion(po.getVersion());
        bo.setIpAddress(po.getIpAddress());
        bo.setRestUrl(po.getRestUrl());
        bo.setRetryTimes(po.getRetryTimes());
        bo.setRetryInterval(po.getRetryInterval());
        bo.setConcurrence(po.getConcurrence());
        bo.setClientOnly(po.getClientOnly());
        bo.setIsDefault(po.getIsdefault());
        bo.setId(po.getId());
        bo.setAppId(po.getAppId());
        bo.setSettingEocFlag(po.getSettingEocFlag());
        return bo;
    }

    public static ProductEntity convertToBOEntity(UnionProductPO po) {
        if (null == po) {
            return null;
        }
        ProductEntity bo = new ProductEntity(ProductType.STANDARD);
        bo.setUid(po.getUid());
        bo.setName(po.getName());
        bo.setApid(po.getApid());
        bo.setVersion(po.getVersion());
        bo.setIpAddress(po.getIpAddress());
        bo.setId(po.getId());
        return bo;
    }


    public static ProductBO convertToBO(UnionProductPO po) {
        if (null == po) {
            return null;
        }
        return new ProductBO(convertToBOEntity(po), null);
    }

    public static ProductPO convertToProductPO(ProductEntity bo) {
        if (null == bo) {
            return null;
        }
        ProductPO po = new ProductPO();
        po.setId(bo.getId());
        po.setApid(bo.getApid());
        po.setUid(bo.getUid());
        po.setConcurrence(bo.getConcurrence());
        po.setIpAddress(bo.getIpAddress());
        po.setName(bo.getName());
        po.setRetryInterval(bo.getRetryInterval());
        po.setRetryTimes(bo.getRetryTimes());
        po.setTimezone(bo.getTimezone());
        po.setVersion(bo.getVersion());
        po.setRestUrl(bo.getRestUrl());
        po.setIsdefault(bo.getIsDefault());
        po.setClientOnly(bo.getClientOnly());
        po.setAppId(bo.getAppId());
        po.setSettingEocFlag(bo.getSettingEocFlag());
        return po;
    }

    public static UnionProductPO convertToUnionProductPO(ProductEntity bo) {
        if (null == bo) {
            return null;
        }
        UnionProductPO po = new UnionProductPO();
        po.setId(bo.getId());
        po.setName(bo.getName());
        po.setVersion(bo.getVersion());
        po.setUid(bo.getUid());
        po.setIpAddress(bo.getIpAddress());
        po.setApid(bo.getApid());
        po.setVersion(bo.getVersion());
        po.setId(bo.getId());
        return po;
    }
}
