package com.digiwin.cross.infrastructure.convertor;

import com.digiwin.cross.domain.bo.entity.ServiceEntity;
import com.digiwin.cross.domain.bo.entity.ServiceProdListEntity;
import com.digiwin.cross.domain.bo.entity.ServiceVersionEntity;
import com.digiwin.cross.infrastructure.database.entity.ServicePO;
import com.digiwin.cross.infrastructure.database.entity.ServiceVersionPO;
import com.digiwin.cross.infrastructure.database.entity.UnionServicePO;
import com.digiwin.cross.infrastructure.rpc.req.ServiceDuplicateAlarmReq;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.logging.log4j.ThreadContext;

import java.util.Calendar;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/6/9 14:09
 */
public class ServiceConvertor {

    public static ServiceEntity convertToServiceBO(ServicePO po, ServiceVersionPO versionPO) {
        if (null == po) {
            return null;
        }
        ServiceEntity bo = new ServiceEntity();
        bo.setId(po.getId());
        bo.setServiceDescription(po.getServiceDescription());
        bo.setServiceName(po.getServiceName());
        bo.setProductId(po.getProductId());
        if (versionPO != null) {
            ServiceVersionEntity versionBO = new ServiceVersionEntity();
            versionBO.setId(versionPO.getId());
            versionBO.setSrvId(versionPO.getSrvId());
            versionBO.setVersion(versionPO.getVersion());
            bo.setVersion(versionBO);
        }
        return bo;
    }

    public static ServiceEntity convertToServiceBO(UnionServicePO po) {
        if (null == po) {
            return null;
        }
        ServiceEntity bo = new ServiceEntity();
        bo.setId(po.getId());
        bo.setServiceName(po.getName());
        bo.setProductId(po.getUnionProductId());
        return bo;
    }

    public static ServicePO convertToSericePO(ServiceEntity serviceBO) {
        if (null == serviceBO) {
            return null;
        }
        ServicePO servicePO = new ServicePO();
        servicePO.setId(serviceBO.getId());
        servicePO.setProductId(serviceBO.getProductId());
        servicePO.setServiceName(serviceBO.getServiceName());
        servicePO.setServiceDescription(serviceBO.getServiceDescription());
        return servicePO;
    }

    public static ServiceVersionPO convertToServiceVersionPO(ServiceVersionEntity versionBO) {
        if (null == versionBO) {
            return null;
        }
        ServiceVersionPO po = new ServiceVersionPO();
        po.setId(versionBO.getId());
        po.setSrvId(versionBO.getSrvId());
        po.setVersion(versionBO.getVersion());
        return po;
    }

    public static UnionServicePO convertToUnionSericePO(ServiceEntity serviceBO) {
        if (null == serviceBO) {
            return null;
        }
        UnionServicePO servicePO = new UnionServicePO();
        servicePO.setId(serviceBO.getId());
        servicePO.setUnionProductId(serviceBO.getProductId());
        servicePO.setName(serviceBO.getServiceName());
        if (serviceBO.getVersion() != null) {
            servicePO.setVersion(serviceBO.getVersion().getVersion());
        }
        return servicePO;
    }

    public static ServiceDuplicateAlarmReq convertToServiceDuplicateAlarmPO(List<ServiceProdListEntity> entityList, String regProd) {
        List<String> serviceList = entityList.stream().map(ServiceProdListEntity::getServiceName).distinct().collect(Collectors.toList());
        List<String> prodList = entityList.stream().flatMap(serviceProdListEntity -> serviceProdListEntity.getProductNames().stream()).distinct().collect(Collectors.toList());
        ServiceDuplicateAlarmReq.Custom tCustom = new ServiceDuplicateAlarmReq.Custom();
        tCustom.setServiceList(serviceList);
        tCustom.setAppCode(regProd);
        tCustom.setRegisteredProd(prodList);

        String pinpointId = ThreadContext.get("PtxId");
        ServiceDuplicateAlarmReq po = new ServiceDuplicateAlarmReq();
        po.setPinpointId(pinpointId);
        po.setCreatedTime(DateFormatUtils.format(Calendar.getInstance().getTime(), ServiceDuplicateAlarmReq.DATE_FORMAT));
        po.setCustom(tCustom);
        return po;
    }
}
