package com.digiwin.cross.infrastructure.database.mapper;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.cross.infrastructure.database.entity.ServicePO;
import com.digiwin.cross.infrastructure.database.entity.ServiceVersionPO;
import org.apache.commons.collections4.CollectionUtils;

import java.util.List;

public interface ServiceVersionMapper extends BaseMapper<ServiceVersionPO> {

    default ServiceVersionPO selectOne(Wrapper<ServiceVersionPO> queryWrapper) {
        List<ServiceVersionPO> list = this.selectList(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            return list.get(0);
        } else {
            return null;
        }
    }

    default int saveOrUpdate(ServiceVersionPO po) {
        if (null == po.getId()) {
            return this.insert(po);
        }
        return this.updateById(po);
    }
}
