package com.digiwin.cross.infrastructure.exception;

import com.digiwin.cross.domain.exception.BaseException;
import com.digiwin.cross.domain.state.StateEnum;

import java.util.Objects;

/**
 * @description:
 * @author: clay
 * @date: 2023/6/27
 */
public class ServiceConnectionFailedException extends BaseException {
    private String httpStatus;

    public ServiceConnectionFailedException(String errorMessage) {
        super(StateEnum.SRV_INVO_CONN, errorMessage);
    }

    public ServiceConnectionFailedException(String errorMessage, Integer httpStatus) {
        super(StateEnum.SRV_INVO_CONN, errorMessage);
        this.httpStatus = Objects.toString(httpStatus, null);
    }

    public ServiceConnectionFailedException(String errorMessage, String httpStatus) {
        super(StateEnum.SRV_INVO_CONN, errorMessage);
        this.httpStatus = httpStatus;
    }

    public ServiceConnectionFailedException(Throwable e) {
        super(StateEnum.SRV_INVO_CONN, e);
        if (e instanceof BaseException) {
            this.httpStatus = ((BaseException) e).getErrorStatus();
        }
    }

    @Override
    public String getErrorStatus() {
        return httpStatus;
    }
}
