package com.digiwin.cross.infrastructure.exception;

import com.digiwin.cross.domain.exception.BaseException;
import com.digiwin.cross.domain.state.StateEnum;
import org.apache.commons.httpclient.HttpStatus;

/**
 * @description:
 * @author: clay
 * @date: 2023/6/21
 */
public class ServiceExecutionTimeoutException extends BaseException {
    public ServiceExecutionTimeoutException() {
        super(StateEnum.SRV_INVO_TIMEOUT);
    }

    public ServiceExecutionTimeoutException(String errorMessage) {
        super(StateEnum.SRV_INVO_TIMEOUT, errorMessage);
    }

    public ServiceExecutionTimeoutException(Throwable e) {
        super(StateEnum.SRV_INVO_TIMEOUT, e);
    }

    @Override
    public String getErrorStatus() {
        return String.valueOf(HttpStatus.SC_GATEWAY_TIMEOUT);
    }
}
