package com.digiwin.cross.infrastructure.gatewayimpl;

import com.digiwin.cross.domain.common.LockNamespaceEnum;
import com.digiwin.cross.domain.gateway.ILockGateway;
import com.digiwin.cross.infrastructure.cache.service.EspRedisService;
import lombok.extern.apachecommons.CommonsLog;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/7/18 10:49
 */
@CommonsLog
@Component
public class LockGateway implements ILockGateway {

    private static Map<String, Lock> lockMap = new ConcurrentHashMap<String, Lock>();

    private final EspRedisService espRedisService;

    public LockGateway (EspRedisService espRedisService) {
        this.espRedisService = espRedisService;
    }

//    @Override
//    public void lock (LockNamespaceEnum lockNamespace, String key) {
//        key = lockNamespace.getName() + key;
//        try {
//            if (redisService.isEnable()) {
//                redisService.tryLock(key);
//            } else {
//                Lock tLock = lockMap.computeIfAbsent(key, k -> new ReentrantLock(true));
//                tLock.lock();
//            }
//        } catch (Exception e) {
//            log.error(String.format("key: %s lock failed", key), e);
//        }
//    }

//    @Override
//    public void lock (LockNamespaceEnum lockNamespace, String key, int lockSeconds) {
//        key = lockNamespace.getName() + key;
//        try {
//            if (redisService.isEnable()) {
//                redisService.tryLock(key, lockSeconds);
//            } else {
//                Lock tLock = lockMap.computeIfAbsent(key, k -> new ReentrantLock(true));
//                tLock.lock();
//            }
//        } catch (Exception e) {
//            log.error(String.format("key: %s lock failed", key), e);
//        }
//    }

    @Override
    public void unlock (LockNamespaceEnum lockNamespace, String key) {
        key = lockNamespace.getName() + key;
        try {
            if (espRedisService.isEnable()) {
                espRedisService.unLock(key);
            } else {
                Lock tLock = lockMap.remove(key);
                tLock.unlock();
            }
        } catch (Exception e) {
            log.error(String.format("key: %s unlock failed", key), e);
        }
    }

    @Override
    public boolean tryLock (LockNamespaceEnum lockNamespace, String key) {
        key = lockNamespace.getName() + key;
        try {
            if (espRedisService.isEnable()) {
                return espRedisService.tryLock(key);
            } else {
                Lock tLock = lockMap.computeIfAbsent(key, k -> new ReentrantLock(true));
                return tLock.tryLock(3, TimeUnit.SECONDS);
            }
        } catch (Exception e) {
            log.error(String.format("key: %s lock failed", key), e);
            return true;
        }
    }

    @Override
    public boolean tryLock (LockNamespaceEnum lockNamespace, String key, int waitSeconds) {
        key = lockNamespace.getName() + key;
        try {
            if (espRedisService.isEnable()) {
                return espRedisService.tryLock(key, waitSeconds);
            } else {
                Lock tLock = lockMap.computeIfAbsent(key, k -> new ReentrantLock(true));
                return tLock.tryLock(waitSeconds, TimeUnit.SECONDS);
            }
        } catch (Exception e) {
            log.error(String.format("key: %s lock failed", key), e);
            return true;
        }
    }

    @Override
    public boolean tryLock (LockNamespaceEnum lockNamespace, String key, int waitSeconds, int maxLockSecond) {
        key = lockNamespace.getName() + key;
        try {
            if (espRedisService.isEnable()) {
                return espRedisService.tryLock(key, waitSeconds, maxLockSecond);
            } else {
                Lock tLock = lockMap.computeIfAbsent(key, k -> new ReentrantLock(true));
                return tLock.tryLock(waitSeconds, TimeUnit.SECONDS);
            }
        } catch (Exception e) {
            log.error(String.format("key: %s lock failed", key), e);
            return true;
        }
    }
}
