package com.digiwin.cross.infrastructure.gatewayimpl;

import com.digiwin.cross.domain.bo.entity.ProductEntity;
import com.digiwin.cross.domain.gateway.IProductEditGateway;
import com.digiwin.cross.domain.gateway.IServiceEditGateway;
import com.digiwin.cross.infrastructure.cache.service.ProductInfoCacheService;
import com.digiwin.cross.infrastructure.convertor.ProductConvertor;
import com.digiwin.cross.infrastructure.database.entity.ProductPO;
import com.digiwin.cross.infrastructure.database.mapper.ProductMapper;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.Calendar;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/6/6 15:38
 */
@Component
public class ProductEditGateway implements IProductEditGateway {

    private final ProductMapper productMapper;

    private final ProductInfoCacheService productInfoCacheService;

    private final IServiceEditGateway serviceEditGateway;

    public ProductEditGateway(ProductMapper productMapper, ProductInfoCacheService productInfoCacheService, IServiceEditGateway serviceEditGateway) {
        this.productMapper = productMapper;
        this.productInfoCacheService = productInfoCacheService;
        this.serviceEditGateway = serviceEditGateway;
    }

    @Override
    public void saveProduct(ProductEntity productBO) {
        ProductPO product = ProductConvertor.convertToProductPO(productBO);
        product.setEncodingState(false);
        product.setBuildTime(Calendar.getInstance().getTime());
        product.setIsvalid(true);
        if (null == product.getClientOnly()) {
            product.setClientOnly(false);
        }
        productMapper.insert(product);
        productBO.setId(product.getId());
        productInfoCacheService.addProduct(product);
    }

    @Override
    public ProductEntity updateProduct(ProductEntity productBO) {
        ProductPO product = ProductConvertor.convertToProductPO(productBO);
        product.setLastUpdateTime(Calendar.getInstance().getTime());
        productMapper.updateById(product);
        product = productMapper.selectById(productBO.getId());
        productInfoCacheService.updateProduct(product);
        return ProductConvertor.convertToBOEntity(product);
    }

    @Transactional("espTransactionManager")
    @Override
    public void deleteProduct(ProductEntity productEntity) {
        ProductPO product = ProductConvertor.convertToProductPO(productEntity);
        productInfoCacheService.deleteProduct(product);
        serviceEditGateway.deleteSrvByProduct(productEntity);
        productMapper.deleteById(productEntity.getId());
    }
}
