package com.digiwin.cross.infrastructure.gatewayimpl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.cross.domain.bo.entity.ProductEntity;
import com.digiwin.cross.domain.bo.entity.ServiceEntity;
import com.digiwin.cross.domain.gateway.IServiceEditGateway;
import com.digiwin.cross.infrastructure.cache.service.ServiceInfoCacheService;
import com.digiwin.cross.infrastructure.convertor.ServiceConvertor;
import com.digiwin.cross.infrastructure.database.entity.ServicePO;
import com.digiwin.cross.infrastructure.database.entity.ServiceVersionPO;
import com.digiwin.cross.infrastructure.database.mapper.ServiceMapper;
import com.digiwin.cross.infrastructure.database.mapper.ServiceVersionMapper;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/6/9 13:57
 */
@Component
public class ServiceEditGateway implements IServiceEditGateway {
    private final static String SERVICE_INVOKE_METHOD_INVOKESRV = "invokeSrv";
    private final static String SRVREG_SRVTYPE = "WS";

    private final ServiceMapper serviceMapper;

    private final ServiceVersionMapper versionMapper;

    private final ServiceInfoCacheService serviceInfoCacheService;

    public ServiceEditGateway(ServiceMapper serviceMapper, ServiceVersionMapper versionMapper, ServiceInfoCacheService serviceInfoCacheService) {
        this.serviceMapper = serviceMapper;
        this.versionMapper = versionMapper;
        this.serviceInfoCacheService = serviceInfoCacheService;
    }

    @Override
    public void saveOrUpdateSrv(ProductEntity productEntity, ServiceEntity srv) {
        ServicePO po = ServiceConvertor.convertToSericePO(srv);
        po.setOperationName(SERVICE_INVOKE_METHOD_INVOKESRV);
        po.setServiceType(SRVREG_SRVTYPE);
        po.setIsenable(true);
        po.setDispatch("API");
        serviceMapper.saveOrUpdate(po);
        srv.setId(po.getId());
        if (null == srv.getVersion()) {
            serviceInfoCacheService.addOrUpdateService(productEntity.getUid(), po);
            return;
        }
        ServiceVersionPO versionPO = ServiceConvertor.convertToServiceVersionPO(srv.getVersion());
        versionPO.setSrvId(po.getId());
        versionMapper.saveOrUpdate(versionPO);
        serviceInfoCacheService.addOrUpdateService(productEntity.getUid(), po);
    }

    @Override
    public void deleteSrv(ProductEntity product, ServiceEntity srv) {
        serviceMapper.deleteById(srv.getId());
        versionMapper.delete(Wrappers.<ServiceVersionPO>lambdaQuery().eq(ServiceVersionPO::getSrvId, srv.getId()));
        serviceInfoCacheService.deleteService(product.getUid(), srv.getServiceName());
    }

    @Override
    public void deleteSrvByProduct(ProductEntity product) {
        List<ServicePO> servicePOList = serviceMapper.selectList(Wrappers.<ServicePO>lambdaQuery().eq(ServicePO::getProductId, product.getId()));
        if (CollectionUtils.isEmpty(servicePOList)) {
            return;
        }
        List<Long> deleteSrvIds = servicePOList.stream().map(ServicePO::getId).collect(Collectors.toList());
        serviceInfoCacheService.deleteServiceByProduct(product.getUid());
        versionMapper.delete(Wrappers.<ServiceVersionPO>lambdaQuery().in(ServiceVersionPO::getSrvId, deleteSrvIds));
        serviceMapper.deleteBatchIds(deleteSrvIds);
    }
}
