package com.digiwin.cross.infrastructure.gatewayimpl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.cross.domain.bo.StateCodeBO;
import com.digiwin.cross.domain.gateway.IStateCodeGateway;
import com.digiwin.cross.infrastructure.convertor.StateCodeConvertor;
import com.digiwin.cross.infrastructure.database.entity.StateCodePO;
import com.digiwin.cross.infrastructure.database.mapper.StateCodeMapper;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @description:
 * @author: clay
 * @date: 2023/7/5
 */
@Component
public class StateCodeGateway implements IStateCodeGateway {


    private Map<String, StateCodePO> stateCodeMap;

    private StateCodeMapper stateCodeMapper;

    public StateCodeGateway(StateCodeMapper stateCodeMapper) {
        this.stateCodeMapper = stateCodeMapper;
    }

    @PostConstruct
    public void init() {
    //    List<StateCodePO> stateCodePOList = stateCodeMapper.selectList(Wrappers.query());
        List<StateCodePO> stateCodePOList = stateCodeMapper.selectList2();
        stateCodeMap = stateCodePOList.stream().collect(Collectors.toMap(StateCodePO::getCode, Function.identity()));
    }

    @Override
    public StateCodeBO getStateCode(String code) {
        StateCodePO tStateCodePO = stateCodeMap.get(code);
        return StateCodeConvertor.convertToStateCodeBO(tStateCodePO);
    }
}
